/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.X509KeyManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.collections.SynchronizedQueue;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.SecureNioChannel;
import org.apache.tomcat.util.net.SocketProperties;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.net.jsse.NioX509KeyManager;

public class NioEndpoint
extends AbstractEndpoint<NioChannel> {
    private static final Log log = LogFactory.getLog(NioEndpoint.class);
    public static final int OP_REGISTER = 256;
    public static final int OP_CALLBACK = 512;
    private NioSelectorPool selectorPool = new NioSelectorPool();
    private ServerSocketChannel serverSock = null;
    private boolean useSendfile = true;
    private int oomParachute = 0x100000;
    private byte[] oomParachuteData = null;
    private static final String oomParachuteMsg = "SEVERE:Memory usage is low, parachute is non existent, your system may start failing.";
    private long lastParachuteCheck = System.currentTimeMillis();
    private volatile CountDownLatch stopLatch = null;
    private SynchronizedStack<SocketProcessor> processorCache;
    private SynchronizedStack<PollerEvent> eventCache;
    private SynchronizedStack<NioChannel> nioChannels;
    private int pollerThreadPriority = 5;
    private Handler handler = null;
    private boolean useComet = true;
    private int pollerThreadCount = Math.min(2, Runtime.getRuntime().availableProcessors());
    private long selectorTimeout = 1000L;
    private Poller[] pollers = null;
    private AtomicInteger pollerRotater = new AtomicInteger(0);
    private SSLContext sslContext = null;
    private String[] enabledCiphers;
    private String[] enabledProtocols;

    @Override
    public boolean setProperty(String name, String value) {
        String selectorPoolName = "selectorPool.";
        try {
            if (name.startsWith("selectorPool.")) {
                return IntrospectionUtils.setProperty(this.selectorPool, name.substring("selectorPool.".length()), value);
            }
            return super.setProperty(name, value);
        }
        catch (Exception x) {
            log.error((Object)("Unable to set attribute \"" + name + "\" to \"" + value + "\""), (Throwable)x);
            return false;
        }
    }

    public void setPollerThreadPriority(int pollerThreadPriority) {
        this.pollerThreadPriority = pollerThreadPriority;
    }

    public int getPollerThreadPriority() {
        return this.pollerThreadPriority;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setUseComet(boolean useComet) {
        this.useComet = useComet;
    }

    @Override
    public boolean getUseComet() {
        return this.useComet;
    }

    @Override
    public boolean getUseCometTimeout() {
        return this.getUseComet();
    }

    @Override
    public boolean getUsePolling() {
        return true;
    }

    public void setPollerThreadCount(int pollerThreadCount) {
        this.pollerThreadCount = pollerThreadCount;
    }

    public int getPollerThreadCount() {
        return this.pollerThreadCount;
    }

    public void setSelectorTimeout(long timeout) {
        this.selectorTimeout = timeout;
    }

    public long getSelectorTimeout() {
        return this.selectorTimeout;
    }

    public Poller getPoller0() {
        int idx = Math.abs(this.pollerRotater.incrementAndGet()) % this.pollers.length;
        return this.pollers[idx];
    }

    public void setSelectorPool(NioSelectorPool selectorPool) {
        this.selectorPool = selectorPool;
    }

    public void setSocketProperties(SocketProperties socketProperties) {
        this.socketProperties = socketProperties;
    }

    public void setUseSendfile(boolean useSendfile) {
        this.useSendfile = useSendfile;
    }

    @Override
    public boolean getDeferAccept() {
        return false;
    }

    public void setOomParachute(int oomParachute) {
        this.oomParachute = oomParachute;
    }

    public void setOomParachuteData(byte[] oomParachuteData) {
        this.oomParachuteData = oomParachuteData;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public void setSSLContext(SSLContext c) {
        this.sslContext = c;
    }

    @Override
    public int getLocalPort() {
        ServerSocketChannel ssc = this.serverSock;
        if (ssc == null) {
            return -1;
        }
        ServerSocket s = ssc.socket();
        if (s == null) {
            return -1;
        }
        return s.getLocalPort();
    }

    @Override
    public String[] getCiphersUsed() {
        return this.enabledCiphers;
    }

    protected void checkParachute() {
        boolean para = this.reclaimParachute(false);
        if (!para && System.currentTimeMillis() - this.lastParachuteCheck > 10000L) {
            try {
                log.fatal((Object)oomParachuteMsg);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                System.err.println(oomParachuteMsg);
            }
            this.lastParachuteCheck = System.currentTimeMillis();
        }
    }

    protected boolean reclaimParachute(boolean force) {
        if (this.oomParachuteData != null) {
            return true;
        }
        if (this.oomParachute > 0 && (force || Runtime.getRuntime().freeMemory() > (long)(this.oomParachute * 2))) {
            this.oomParachuteData = new byte[this.oomParachute];
        }
        return this.oomParachuteData != null;
    }

    protected void releaseCaches() {
        this.nioChannels.clear();
        this.processorCache.clear();
        if (this.handler != null) {
            this.handler.recycle();
        }
    }

    public int getKeepAliveCount() {
        if (this.pollers == null) {
            return 0;
        }
        int sum = 0;
        for (int i = 0; i < this.pollers.length; ++i) {
            sum += this.pollers[i].getKeyCount();
        }
        return sum;
    }

    @Override
    public void bind() throws Exception {
        this.serverSock = ServerSocketChannel.open();
        this.socketProperties.setProperties(this.serverSock.socket());
        InetSocketAddress addr = this.getAddress() != null ? new InetSocketAddress(this.getAddress(), this.getPort()) : new InetSocketAddress(this.getPort());
        this.serverSock.socket().bind(addr, this.getBacklog());
        this.serverSock.configureBlocking(true);
        this.serverSock.socket().setSoTimeout(this.getSocketProperties().getSoTimeout());
        if (this.acceptorThreadCount == 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.pollerThreadCount <= 0) {
            this.pollerThreadCount = 1;
        }
        this.stopLatch = new CountDownLatch(this.pollerThreadCount);
        if (this.isSSLEnabled()) {
            SSLUtil sslUtil = this.handler.getSslImplementation().getSSLUtil(this);
            this.sslContext = sslUtil.createSSLContext();
            this.sslContext.init(this.wrap(sslUtil.getKeyManagers()), sslUtil.getTrustManagers(), null);
            SSLSessionContext sessionContext = this.sslContext.getServerSessionContext();
            if (sessionContext != null) {
                sslUtil.configureSessionContext(sessionContext);
            }
            this.enabledCiphers = sslUtil.getEnableableCiphers(this.sslContext);
            this.enabledProtocols = sslUtil.getEnableableProtocols(this.sslContext);
        }
        if (this.oomParachute > 0) {
            this.reclaimParachute(true);
        }
        this.selectorPool.open();
    }

    public KeyManager[] wrap(KeyManager[] managers) {
        if (managers == null) {
            return null;
        }
        KeyManager[] result = new KeyManager[managers.length];
        for (int i = 0; i < result.length; ++i) {
            if (managers[i] instanceof X509KeyManager && this.getKeyAlias() != null) {
                String keyAlias = this.getKeyAlias();
                if ("jks".equalsIgnoreCase(this.getKeystoreType())) {
                    keyAlias = keyAlias.toLowerCase(Locale.ENGLISH);
                }
                result[i] = new NioX509KeyManager((X509KeyManager)managers[i], keyAlias);
                continue;
            }
            result[i] = managers[i];
        }
        return result;
    }

    @Override
    public void startInternal() throws Exception {
        if (!this.running) {
            this.running = true;
            this.paused = false;
            this.processorCache = new SynchronizedStack(128, this.socketProperties.getProcessorCache());
            this.eventCache = new SynchronizedStack(128, this.socketProperties.getEventCache());
            this.nioChannels = new SynchronizedStack(128, this.socketProperties.getBufferPool());
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
            this.initializeConnectionLatch();
            this.pollers = new Poller[this.getPollerThreadCount()];
            for (int i = 0; i < this.pollers.length; ++i) {
                this.pollers[i] = new Poller();
                Thread pollerThread = new Thread((Runnable)this.pollers[i], this.getName() + "-ClientPoller-" + i);
                pollerThread.setPriority(this.threadPriority);
                pollerThread.setDaemon(true);
                pollerThread.start();
            }
            this.startAcceptorThreads();
        }
    }

    @Override
    public void stopInternal() {
        this.releaseConnectionLatch();
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            this.running = false;
            this.unlockAccept();
            for (int i = 0; this.pollers != null && i < this.pollers.length; ++i) {
                if (this.pollers[i] == null) continue;
                this.pollers[i].destroy();
                this.pollers[i] = null;
            }
            try {
                this.stopLatch.await(this.selectorTimeout + 100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.shutdownExecutor();
            this.eventCache.clear();
            this.nioChannels.clear();
            this.processorCache.clear();
        }
    }

    @Override
    public void unbind() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroy initiated for " + new InetSocketAddress(this.getAddress(), this.getPort())));
        }
        if (this.running) {
            this.stop();
        }
        this.serverSock.socket().close();
        this.serverSock.close();
        this.serverSock = null;
        this.sslContext = null;
        this.releaseCaches();
        this.selectorPool.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroy completed for " + new InetSocketAddress(this.getAddress(), this.getPort())));
        }
    }

    public int getWriteBufSize() {
        return this.socketProperties.getTxBufSize();
    }

    public int getReadBufSize() {
        return this.socketProperties.getRxBufSize();
    }

    public NioSelectorPool getSelectorPool() {
        return this.selectorPool;
    }

    @Override
    public boolean getUseSendfile() {
        return this.useSendfile;
    }

    public int getOomParachute() {
        return this.oomParachute;
    }

    public byte[] getOomParachuteData() {
        return this.oomParachuteData;
    }

    @Override
    protected AbstractEndpoint.Acceptor createAcceptor() {
        return new Acceptor();
    }

    protected boolean setSocketOptions(SocketChannel socket) {
        try {
            socket.configureBlocking(false);
            Socket sock = socket.socket();
            this.socketProperties.setProperties(sock);
            NioChannel channel = this.nioChannels.pop();
            if (channel == null) {
                if (this.sslContext != null) {
                    SSLEngine engine = this.createSSLEngine();
                    int appbufsize = engine.getSession().getApplicationBufferSize();
                    NioBufferHandler bufhandler = new NioBufferHandler(Math.max(appbufsize, this.socketProperties.getAppReadBufSize()), Math.max(appbufsize, this.socketProperties.getAppWriteBufSize()), this.socketProperties.getDirectBuffer());
                    channel = new SecureNioChannel(socket, engine, bufhandler, this.selectorPool);
                } else {
                    NioBufferHandler bufhandler = new NioBufferHandler(this.socketProperties.getAppReadBufSize(), this.socketProperties.getAppWriteBufSize(), this.socketProperties.getDirectBuffer());
                    channel = new NioChannel(socket, bufhandler);
                }
            } else {
                channel.setIOChannel(socket);
                if (channel instanceof SecureNioChannel) {
                    SSLEngine engine = this.createSSLEngine();
                    ((SecureNioChannel)channel).reset(engine);
                } else {
                    channel.reset();
                }
            }
            this.getPoller0().register(channel);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            try {
                log.error((Object)"", t);
            }
            catch (Throwable tt) {
                ExceptionUtils.handleThrowable(t);
            }
            return false;
        }
        return true;
    }

    protected SSLEngine createSSLEngine() {
        SSLEngine engine = this.sslContext.createSSLEngine();
        if ("false".equals(this.getClientAuth())) {
            engine.setNeedClientAuth(false);
            engine.setWantClientAuth(false);
        } else if ("true".equals(this.getClientAuth()) || "yes".equals(this.getClientAuth())) {
            engine.setNeedClientAuth(true);
        } else if ("want".equals(this.getClientAuth())) {
            engine.setWantClientAuth(true);
        }
        engine.setUseClientMode(false);
        engine.setEnabledCipherSuites(this.enabledCiphers);
        engine.setEnabledProtocols(this.enabledProtocols);
        this.configureUseServerCipherSuitesOrder(engine);
        return engine;
    }

    protected boolean isWorkerAvailable() {
        return true;
    }

    @Override
    public void processSocket(SocketWrapper<NioChannel> socketWrapper, SocketStatus socketStatus, boolean dispatch) {
        NioChannel socket = socketWrapper.getSocket();
        if (socket.isOpen() && dispatch && socketStatus == SocketStatus.OPEN_READ) {
            socket.getPoller().add(socket, 512);
        } else {
            this.processSocket((KeyAttachment)socketWrapper, socketStatus, dispatch);
        }
    }

    protected boolean processSocket(KeyAttachment attachment, SocketStatus status, boolean dispatch) {
        try {
            if (attachment == null) {
                return false;
            }
            attachment.setCometNotify(false);
            SocketProcessor sc = this.processorCache.pop();
            if (sc == null) {
                sc = new SocketProcessor(attachment, status);
            } else {
                sc.reset(attachment, status);
            }
            Executor executor = this.getExecutor();
            if (dispatch && executor != null) {
                executor.execute(sc);
            } else {
                sc.run();
            }
        }
        catch (RejectedExecutionException ree) {
            log.warn((Object)sm.getString("endpoint.executor.fail", attachment.getSocket()), (Throwable)ree);
            return false;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error((Object)sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    private void closeSocket(SocketChannel socket) {
        block5: {
            block4: {
                try {
                    socket.socket().close();
                }
                catch (IOException ioe) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"", (Throwable)ioe);
                }
            }
            try {
                socket.close();
            }
            catch (IOException ioe) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)"", (Throwable)ioe);
            }
        }
    }

    static /* synthetic */ byte[] access$302(NioEndpoint x0, byte[] x1) {
        x0.oomParachuteData = x1;
        return x1;
    }

    public static class SendfileData {
        public volatile String fileName;
        public volatile FileChannel fchannel;
        public volatile long pos;
        public volatile long length;
        public volatile boolean keepAlive;
    }

    protected class SocketProcessor
    implements Runnable {
        private KeyAttachment ka = null;
        private SocketStatus status = null;

        public SocketProcessor(KeyAttachment ka, SocketStatus status) {
            this.reset(ka, status);
        }

        public void reset(KeyAttachment ka, SocketStatus status) {
            this.ka = ka;
            this.status = status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NioChannel socket = (NioChannel)this.ka.getSocket();
            if (this.ka.isUpgraded() && SocketStatus.OPEN_WRITE == this.status) {
                Object object = this.ka.getWriteThreadLock();
                synchronized (object) {
                    this.doRun();
                }
            }
            NioChannel nioChannel = socket;
            synchronized (nioChannel) {
                this.doRun();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRun() {
            NioChannel socket = (NioChannel)this.ka.getSocket();
            SelectionKey key = socket.getIOChannel().keyFor(socket.getPoller().getSelector());
            try {
                int handshake = -1;
                try {
                    if (key != null) {
                        if (socket.isHandshakeComplete() || this.status == SocketStatus.STOP) {
                            handshake = 0;
                        } else {
                            handshake = socket.handshake(key.isReadable(), key.isWritable());
                            this.status = SocketStatus.OPEN_READ;
                        }
                    }
                }
                catch (IOException x) {
                    handshake = -1;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Error during SSL handshake", (Throwable)x);
                    }
                }
                catch (CancelledKeyException ckx) {
                    handshake = -1;
                }
                if (handshake == 0) {
                    AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.OPEN;
                    state = this.status == null ? NioEndpoint.this.handler.process(this.ka, SocketStatus.OPEN_READ) : NioEndpoint.this.handler.process(this.ka, this.status);
                    if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        this.close(socket, key, SocketStatus.ERROR);
                    }
                } else if (handshake == -1) {
                    this.close(socket, key, SocketStatus.DISCONNECT);
                } else {
                    this.ka.getPoller().add(socket, handshake);
                }
            }
            catch (CancelledKeyException cx) {
                socket.getPoller().cancelledKey(key, null);
            }
            catch (OutOfMemoryError oom) {
                try {
                    NioEndpoint.access$302(NioEndpoint.this, null);
                    log.error((Object)"", (Throwable)oom);
                    socket.getPoller().cancelledKey(key, SocketStatus.ERROR);
                    NioEndpoint.this.releaseCaches();
                }
                catch (Throwable oomt) {
                    try {
                        System.err.println(NioEndpoint.oomParachuteMsg);
                        oomt.printStackTrace();
                    }
                    catch (Throwable letsHopeWeDontGetHere) {
                        ExceptionUtils.handleThrowable(letsHopeWeDontGetHere);
                    }
                }
            }
            catch (VirtualMachineError vme) {
                ExceptionUtils.handleThrowable(vme);
            }
            catch (Throwable t) {
                log.error((Object)"", t);
                socket.getPoller().cancelledKey(key, SocketStatus.ERROR);
            }
            finally {
                this.ka = null;
                this.status = null;
                if (NioEndpoint.this.running && !NioEndpoint.this.paused) {
                    NioEndpoint.this.processorCache.push(this);
                }
            }
        }

        private void close(NioChannel socket, SelectionKey key, SocketStatus socketStatus) {
            try {
                this.ka.setComet(false);
                if (socket.getPoller().cancelledKey(key, socketStatus) != null && NioEndpoint.this.running && !NioEndpoint.this.paused) {
                    NioEndpoint.this.nioChannels.push(socket);
                }
            }
            catch (Exception x) {
                log.error((Object)"", (Throwable)x);
            }
        }
    }

    public static interface Handler
    extends AbstractEndpoint.Handler {
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<NioChannel> var1, SocketStatus var2);

        public void release(SocketWrapper<NioChannel> var1);

        public void release(SocketChannel var1);

        public SSLImplementation getSslImplementation();
    }

    public static class NioBufferHandler
    implements SecureNioChannel.ApplicationBufferHandler {
        private ByteBuffer readbuf = null;
        private ByteBuffer writebuf = null;

        public NioBufferHandler(int readsize, int writesize, boolean direct) {
            if (direct) {
                this.readbuf = ByteBuffer.allocateDirect(readsize);
                this.writebuf = ByteBuffer.allocateDirect(writesize);
            } else {
                this.readbuf = ByteBuffer.allocate(readsize);
                this.writebuf = ByteBuffer.allocate(writesize);
            }
        }

        @Override
        public ByteBuffer expand(ByteBuffer buffer, int remaining) {
            return buffer;
        }

        @Override
        public ByteBuffer getReadBuffer() {
            return this.readbuf;
        }

        @Override
        public ByteBuffer getWriteBuffer() {
            return this.writebuf;
        }
    }

    public static class KeyAttachment
    extends SocketWrapper<NioChannel> {
        private Poller poller = null;
        private int interestOps = 0;
        private boolean cometNotify = false;
        private CountDownLatch readLatch = null;
        private CountDownLatch writeLatch = null;
        private volatile SendfileData sendfileData = null;
        private long writeTimeout = -1L;

        public KeyAttachment(NioChannel channel) {
            super(channel);
        }

        public Poller getPoller() {
            return this.poller;
        }

        public void setPoller(Poller poller) {
            this.poller = poller;
        }

        public void setCometNotify(boolean notify) {
            this.cometNotify = notify;
        }

        public boolean getCometNotify() {
            return this.cometNotify;
        }

        public int interestOps() {
            return this.interestOps;
        }

        public int interestOps(int ops) {
            this.interestOps = ops;
            return ops;
        }

        public CountDownLatch getReadLatch() {
            return this.readLatch;
        }

        public CountDownLatch getWriteLatch() {
            return this.writeLatch;
        }

        protected CountDownLatch resetLatch(CountDownLatch latch) {
            if (latch == null || latch.getCount() == 0L) {
                return null;
            }
            throw new IllegalStateException("Latch must be at count 0");
        }

        public void resetReadLatch() {
            this.readLatch = this.resetLatch(this.readLatch);
        }

        public void resetWriteLatch() {
            this.writeLatch = this.resetLatch(this.writeLatch);
        }

        protected CountDownLatch startLatch(CountDownLatch latch, int cnt) {
            if (latch == null || latch.getCount() == 0L) {
                return new CountDownLatch(cnt);
            }
            throw new IllegalStateException("Latch must be at count 0 or null.");
        }

        public void startReadLatch(int cnt) {
            this.readLatch = this.startLatch(this.readLatch, cnt);
        }

        public void startWriteLatch(int cnt) {
            this.writeLatch = this.startLatch(this.writeLatch, cnt);
        }

        protected void awaitLatch(CountDownLatch latch, long timeout, TimeUnit unit) throws InterruptedException {
            if (latch == null) {
                throw new IllegalStateException("Latch cannot be null");
            }
            latch.await(timeout, unit);
        }

        public void awaitReadLatch(long timeout, TimeUnit unit) throws InterruptedException {
            this.awaitLatch(this.readLatch, timeout, unit);
        }

        public void awaitWriteLatch(long timeout, TimeUnit unit) throws InterruptedException {
            this.awaitLatch(this.writeLatch, timeout, unit);
        }

        public void setSendfileData(SendfileData sf) {
            this.sendfileData = sf;
        }

        public SendfileData getSendfileData() {
            return this.sendfileData;
        }

        public void setWriteTimeout(long writeTimeout) {
            this.writeTimeout = writeTimeout;
        }

        public long getWriteTimeout() {
            return this.writeTimeout;
        }
    }

    public class Poller
    implements Runnable {
        private Selector selector;
        private final SynchronizedQueue<PollerEvent> events = new SynchronizedQueue();
        private volatile boolean close = false;
        private long nextExpiration = 0L;
        private AtomicLong wakeupCounter = new AtomicLong(0L);
        private volatile int keyCount = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Poller() throws IOException {
            Class<Selector> clazz = Selector.class;
            synchronized (Selector.class) {
                this.selector = Selector.open();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public int getKeyCount() {
            return this.keyCount;
        }

        public Selector getSelector() {
            return this.selector;
        }

        protected void destroy() {
            this.close = true;
            this.selector.wakeup();
        }

        private void addEvent(PollerEvent event) {
            this.events.offer(event);
            if (this.wakeupCounter.incrementAndGet() == 0L) {
                this.selector.wakeup();
            }
        }

        public void add(NioChannel socket) {
            this.add(socket, 1);
        }

        public void add(NioChannel socket, int interestOps) {
            PollerEvent r = (PollerEvent)NioEndpoint.this.eventCache.pop();
            if (r == null) {
                r = new PollerEvent(socket, null, interestOps);
            } else {
                r.reset(socket, null, interestOps);
            }
            if ((interestOps & 0x200) == 512) {
                this.nextExpiration = 0L;
            }
            this.addEvent(r);
            if (this.close) {
                KeyAttachment ka = (KeyAttachment)socket.getAttachment();
                NioEndpoint.this.processSocket(ka, SocketStatus.STOP, false);
            }
        }

        public boolean events() {
            boolean result = false;
            PollerEvent pe = null;
            while ((pe = this.events.poll()) != null) {
                result = true;
                try {
                    pe.run();
                    pe.reset();
                    if (!NioEndpoint.this.running || NioEndpoint.this.paused) continue;
                    NioEndpoint.this.eventCache.push(pe);
                }
                catch (Throwable x) {
                    log.error((Object)"", x);
                }
            }
            return result;
        }

        public void register(NioChannel socket) {
            socket.setPoller(this);
            KeyAttachment ka = new KeyAttachment(socket);
            ka.setPoller(this);
            ka.setTimeout(NioEndpoint.this.getSocketProperties().getSoTimeout());
            ka.setKeepAliveLeft(NioEndpoint.this.getMaxKeepAliveRequests());
            ka.setSecure(NioEndpoint.this.isSSLEnabled());
            PollerEvent r = (PollerEvent)NioEndpoint.this.eventCache.pop();
            ka.interestOps(1);
            if (r == null) {
                r = new PollerEvent(socket, ka, 256);
            } else {
                r.reset(socket, ka, 256);
            }
            this.addEvent(r);
        }

        public KeyAttachment cancelledKey(SelectionKey key, SocketStatus status) {
            KeyAttachment ka;
            block22: {
                ka = null;
                try {
                    block21: {
                        block20: {
                            if (key == null) {
                                return null;
                            }
                            ka = (KeyAttachment)key.attachment();
                            if (ka != null && ka.isComet() && status != null) {
                                ka.setComet(false);
                                if (status == SocketStatus.TIMEOUT) {
                                    if (NioEndpoint.this.processSocket(ka, status, true)) {
                                        return null;
                                    }
                                } else {
                                    NioEndpoint.this.processSocket(ka, status, false);
                                }
                            }
                            if ((ka = (KeyAttachment)key.attach(null)) != null) {
                                NioEndpoint.this.handler.release(ka);
                            } else {
                                NioEndpoint.this.handler.release((SocketChannel)key.channel());
                            }
                            if (key.isValid()) {
                                key.cancel();
                            }
                            if (key.channel().isOpen()) {
                                try {
                                    key.channel().close();
                                }
                                catch (Exception e) {
                                    if (!log.isDebugEnabled()) break block20;
                                    log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.channelCloseFail"), (Throwable)e);
                                }
                            }
                        }
                        try {
                            if (ka != null) {
                                ((NioChannel)ka.getSocket()).close(true);
                            }
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) break block21;
                            log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.socketCloseFail"), (Throwable)e);
                        }
                    }
                    try {
                        if (ka != null && ka.getSendfileData() != null && ka.getSendfileData().fchannel != null && ka.getSendfileData().fchannel.isOpen()) {
                            ka.getSendfileData().fchannel.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (ka != null) {
                        NioEndpoint.this.countDownConnection();
                    }
                }
                catch (Throwable e) {
                    ExceptionUtils.handleThrowable(e);
                    if (!log.isDebugEnabled()) break block22;
                    log.error((Object)"", e);
                }
            }
            return ka;
        }

        @Override
        public void run() {
            block14: while (true) {
                try {
                    while (true) {
                        Iterator<SelectionKey> iterator;
                        if (NioEndpoint.this.paused && !this.close) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        boolean hasEvents = false;
                        if (this.close) {
                            this.events();
                            this.timeout(0, false);
                            try {
                                this.selector.close();
                            }
                            catch (IOException ioe) {
                                log.error((Object)AbstractEndpoint.sm.getString("endpoint.nio.selectorCloseFail"), (Throwable)ioe);
                            }
                            break block14;
                        }
                        hasEvents = this.events();
                        try {
                            if (!this.close) {
                                this.keyCount = this.wakeupCounter.getAndSet(-1L) > 0L ? this.selector.selectNow() : this.selector.select(NioEndpoint.this.selectorTimeout);
                                this.wakeupCounter.set(0L);
                            }
                            if (this.close) {
                                this.events();
                                this.timeout(0, false);
                                try {
                                    this.selector.close();
                                }
                                catch (IOException ioe) {
                                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.nio.selectorCloseFail"), (Throwable)ioe);
                                }
                                break block14;
                            }
                        }
                        catch (Throwable x) {
                            ExceptionUtils.handleThrowable(x);
                            log.error((Object)"", x);
                            continue;
                        }
                        if (this.keyCount == 0) {
                            hasEvents |= this.events();
                        }
                        Iterator<SelectionKey> iterator2 = iterator = this.keyCount > 0 ? this.selector.selectedKeys().iterator() : null;
                        while (iterator != null && iterator.hasNext()) {
                            SelectionKey sk = iterator.next();
                            KeyAttachment attachment = (KeyAttachment)sk.attachment();
                            if (attachment == null) {
                                iterator.remove();
                                continue;
                            }
                            attachment.access();
                            iterator.remove();
                            this.processKey(sk, attachment);
                        }
                        this.timeout(this.keyCount, hasEvents);
                        if (NioEndpoint.this.oomParachute <= 0 || NioEndpoint.this.oomParachuteData != null) continue;
                        NioEndpoint.this.checkParachute();
                    }
                }
                catch (OutOfMemoryError oom) {
                    try {
                        NioEndpoint.access$302(NioEndpoint.this, null);
                        NioEndpoint.this.releaseCaches();
                        log.error((Object)"", (Throwable)oom);
                    }
                    catch (Throwable oomt) {
                        try {
                            System.err.println(NioEndpoint.oomParachuteMsg);
                            oomt.printStackTrace();
                        }
                        catch (Throwable letsHopeWeDontGetHere) {
                            ExceptionUtils.handleThrowable(letsHopeWeDontGetHere);
                        }
                    }
                    continue;
                }
                break;
            }
            NioEndpoint.this.stopLatch.countDown();
        }

        protected boolean processKey(SelectionKey sk, KeyAttachment attachment) {
            boolean result = true;
            try {
                if (this.close) {
                    this.cancelledKey(sk, SocketStatus.STOP);
                } else if (sk.isValid() && attachment != null) {
                    attachment.access();
                    if (sk.isReadable() || sk.isWritable()) {
                        if (attachment.getSendfileData() != null) {
                            this.processSendfile(sk, attachment, false);
                        } else if (NioEndpoint.this.isWorkerAvailable()) {
                            this.unreg(sk, attachment, sk.readyOps());
                            boolean closeSocket = false;
                            if (sk.isReadable() && !NioEndpoint.this.processSocket(attachment, SocketStatus.OPEN_READ, true)) {
                                closeSocket = true;
                            }
                            if (!closeSocket && sk.isWritable() && !NioEndpoint.this.processSocket(attachment, SocketStatus.OPEN_WRITE, true)) {
                                closeSocket = true;
                            }
                            if (closeSocket) {
                                this.cancelledKey(sk, SocketStatus.DISCONNECT);
                            }
                        } else {
                            result = false;
                        }
                    }
                } else {
                    this.cancelledKey(sk, SocketStatus.ERROR);
                }
            }
            catch (CancelledKeyException ckx) {
                this.cancelledKey(sk, SocketStatus.ERROR);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                log.error((Object)"", t);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean processSendfile(SelectionKey sk, KeyAttachment attachment, boolean event) {
            NioChannel sc = null;
            try {
                ByteChannel byteChannel;
                this.unreg(sk, attachment, sk.readyOps());
                SendfileData sd = attachment.getSendfileData();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Processing send file for: " + sd.fileName));
                }
                if (sd.fchannel == null) {
                    File file = new File(sd.fileName);
                    if (!file.exists()) {
                        this.cancelledKey(sk, SocketStatus.ERROR);
                        boolean bl = false;
                        return bl;
                    }
                    FileInputStream fis = new FileInputStream(file);
                    sd.fchannel = fis.getChannel();
                }
                sc = (NioChannel)attachment.getSocket();
                sc.setSendFile(true);
                ByteChannel byteChannel2 = byteChannel = sc instanceof SecureNioChannel ? sc : sc.getIOChannel();
                if (sc.getOutboundRemaining() > 0) {
                    if (sc.flushOutbound()) {
                        attachment.access();
                    }
                } else {
                    long written = sd.fchannel.transferTo(sd.pos, sd.length, byteChannel);
                    if (written > 0L) {
                        sd.pos += written;
                        sd.length -= written;
                        attachment.access();
                    } else if (sd.fchannel.size() <= sd.pos) {
                        throw new IOException("Sendfile configured to send more data than was available");
                    }
                }
                if (sd.length <= 0L && sc.getOutboundRemaining() <= 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Send file complete for: " + sd.fileName));
                    }
                    attachment.setSendfileData(null);
                    try {
                        sd.fchannel.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (sd.keepAlive) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Connection is keep alive, registering back for OP_READ");
                        }
                        if (event) {
                            this.add((NioChannel)attachment.getSocket(), 1);
                            return true;
                        }
                        this.reg(sk, attachment, 1);
                        return true;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Send file connection is being closed");
                    }
                    this.cancelledKey(sk, SocketStatus.STOP);
                    boolean bl = false;
                    return bl;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("OP_WRITE for sendfile: " + sd.fileName));
                }
                if (event) {
                    this.add((NioChannel)attachment.getSocket(), 4);
                    return true;
                }
                this.reg(sk, attachment, 4);
                return true;
            }
            catch (IOException x) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unable to complete sendfile request:", (Throwable)x);
                }
                this.cancelledKey(sk, SocketStatus.ERROR);
                boolean bl = false;
                return bl;
            }
            catch (Throwable t) {
                log.error((Object)"", t);
                this.cancelledKey(sk, SocketStatus.ERROR);
                boolean bl = false;
                return bl;
            }
            finally {
                if (sc != null) {
                    sc.setSendFile(false);
                }
            }
        }

        protected void unreg(SelectionKey sk, KeyAttachment attachment, int readyOps) {
            this.reg(sk, attachment, sk.interestOps() & ~readyOps);
        }

        protected void reg(SelectionKey sk, KeyAttachment attachment, int intops) {
            sk.interestOps(intops);
            attachment.interestOps(intops);
        }

        protected void timeout(int keyCount, boolean hasEvents) {
            long now = System.currentTimeMillis();
            if (this.nextExpiration > 0L && (keyCount > 0 || hasEvents) && now < this.nextExpiration && !this.close) {
                return;
            }
            Set<SelectionKey> keys = this.selector.keys();
            int keycount = 0;
            try {
                for (SelectionKey key : keys) {
                    ++keycount;
                    try {
                        long delta;
                        boolean isTimedout;
                        long timeout;
                        KeyAttachment ka = (KeyAttachment)key.attachment();
                        if (ka == null) {
                            this.cancelledKey(key, SocketStatus.ERROR);
                            continue;
                        }
                        if (ka.getError()) {
                            this.cancelledKey(key, SocketStatus.ERROR);
                            continue;
                        }
                        if (ka.getCometNotify()) {
                            ka.setCometNotify(false);
                            int ops = ka.interestOps() & 0xFFFFFDFF;
                            this.reg(key, ka, 0);
                            ka.interestOps(ops);
                            if (NioEndpoint.this.processSocket(ka, SocketStatus.OPEN_READ, true)) continue;
                            NioEndpoint.this.processSocket(ka, SocketStatus.DISCONNECT, true);
                            continue;
                        }
                        if ((ka.interestOps() & 1) == 1 || (ka.interestOps() & 4) == 4) {
                            long delta2 = now - ka.getLastAccess();
                            timeout = ka.getTimeout();
                            boolean bl = isTimedout = timeout > 0L && delta2 > timeout;
                            if (this.close) {
                                key.interestOps(0);
                                ka.interestOps(0);
                                this.processKey(key, ka);
                                continue;
                            }
                            if (!isTimedout) continue;
                            key.interestOps(0);
                            ka.interestOps(0);
                            this.cancelledKey(key, SocketStatus.TIMEOUT);
                            continue;
                        }
                        if (!ka.isAsync() && !ka.isComet()) continue;
                        if (this.close) {
                            key.interestOps(0);
                            ka.interestOps(0);
                            this.processKey(key, ka);
                            continue;
                        }
                        if (ka.isAsync() && ka.getTimeout() <= 0L || !(isTimedout = (delta = now - ka.getLastAccess()) > (timeout = ka.getTimeout() == -1L ? (long)NioEndpoint.this.socketProperties.getSoTimeout() : ka.getTimeout()))) continue;
                        ka.access(Long.MAX_VALUE);
                        NioEndpoint.this.processSocket(ka, SocketStatus.TIMEOUT, true);
                    }
                    catch (CancelledKeyException ckx) {
                        this.cancelledKey(key, SocketStatus.ERROR);
                    }
                }
            }
            catch (ConcurrentModificationException cme) {
                log.warn((Object)AbstractEndpoint.sm.getString("endpoint.nio.timeoutCme"), (Throwable)cme);
            }
            long prevExp = this.nextExpiration;
            this.nextExpiration = System.currentTimeMillis() + NioEndpoint.this.socketProperties.getTimeoutInterval();
            if (log.isTraceEnabled()) {
                log.trace((Object)("timeout completed: keys processed=" + keycount + "; now=" + now + "; nextExpiration=" + prevExp + "; keyCount=" + keyCount + "; hasEvents=" + hasEvents + "; eval=" + (now < prevExp && (keyCount > 0 || hasEvents) && !this.close)));
            }
        }
    }

    public static class PollerEvent
    implements Runnable {
        private NioChannel socket;
        private int interestOps;
        private KeyAttachment key;

        public PollerEvent(NioChannel ch, KeyAttachment k, int intOps) {
            this.reset(ch, k, intOps);
        }

        public void reset(NioChannel ch, KeyAttachment k, int intOps) {
            this.socket = ch;
            this.interestOps = intOps;
            this.key = k;
        }

        public void reset() {
            this.reset(null, null, 0);
        }

        @Override
        public void run() {
            if (this.interestOps == 256) {
                try {
                    this.socket.getIOChannel().register(this.socket.getPoller().getSelector(), 1, this.key);
                }
                catch (Exception x) {
                    log.error((Object)"", (Throwable)x);
                }
            } else {
                SelectionKey key = this.socket.getIOChannel().keyFor(this.socket.getPoller().getSelector());
                try {
                    boolean cancel = false;
                    if (key != null) {
                        KeyAttachment att = (KeyAttachment)key.attachment();
                        if (att != null) {
                            if ((this.interestOps & 0x200) == 512) {
                                att.setCometNotify(true);
                            } else {
                                att.setCometNotify(false);
                            }
                            this.interestOps &= 0xFFFFFDFF;
                            att.access();
                            int ops = key.interestOps() | this.interestOps;
                            att.interestOps(ops);
                            if (att.getCometNotify()) {
                                key.interestOps(0);
                            } else {
                                key.interestOps(ops);
                            }
                        } else {
                            cancel = true;
                        }
                    } else {
                        cancel = true;
                    }
                    if (cancel) {
                        this.socket.getPoller().cancelledKey(key, SocketStatus.ERROR);
                    }
                }
                catch (CancelledKeyException ckx) {
                    try {
                        this.socket.getPoller().cancelledKey(key, SocketStatus.DISCONNECT);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public String toString() {
            return super.toString() + "[intOps=" + this.interestOps + "]";
        }
    }

    protected class Acceptor
    extends AbstractEndpoint.Acceptor {
        protected Acceptor() {
        }

        @Override
        public void run() {
            int errorDelay = 0;
            while (NioEndpoint.this.running) {
                while (NioEndpoint.this.paused && NioEndpoint.this.running) {
                    this.state = AbstractEndpoint.Acceptor.AcceptorState.PAUSED;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!NioEndpoint.this.running) break;
                this.state = AbstractEndpoint.Acceptor.AcceptorState.RUNNING;
                try {
                    NioEndpoint.this.countUpOrAwaitConnection();
                    SocketChannel socket = null;
                    try {
                        socket = NioEndpoint.this.serverSock.accept();
                    }
                    catch (IOException ioe) {
                        NioEndpoint.this.countDownConnection();
                        errorDelay = NioEndpoint.this.handleExceptionWithDelay(errorDelay);
                        throw ioe;
                    }
                    errorDelay = 0;
                    if (NioEndpoint.this.running && !NioEndpoint.this.paused) {
                        if (NioEndpoint.this.setSocketOptions(socket)) continue;
                        NioEndpoint.this.countDownConnection();
                        NioEndpoint.this.closeSocket(socket);
                        continue;
                    }
                    NioEndpoint.this.countDownConnection();
                    NioEndpoint.this.closeSocket(socket);
                }
                catch (SocketTimeoutException socket) {
                }
                catch (IOException x) {
                    if (!NioEndpoint.this.running) continue;
                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.accept.fail"), (Throwable)x);
                }
                catch (OutOfMemoryError oom) {
                    try {
                        NioEndpoint.access$302(NioEndpoint.this, null);
                        NioEndpoint.this.releaseCaches();
                        log.error((Object)"", (Throwable)oom);
                    }
                    catch (Throwable oomt) {
                        try {
                            try {
                                System.err.println(NioEndpoint.oomParachuteMsg);
                                oomt.printStackTrace();
                            }
                            catch (Throwable letsHopeWeDontGetHere) {
                                ExceptionUtils.handleThrowable(letsHopeWeDontGetHere);
                            }
                        }
                        catch (Throwable letsHopeWeDontGetHere) {
                            ExceptionUtils.handleThrowable(letsHopeWeDontGetHere);
                        }
                    }
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.accept.fail"), t);
                }
            }
            this.state = AbstractEndpoint.Acceptor.AcceptorState.ENDED;
        }
    }
}

