/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.xml.ClassLoadingHelper;
import org.hibernate.validator.internal.xml.GroupConversionType;

class GroupConversionBuilder {
    private GroupConversionBuilder() {
    }

    static Map<Class<?>, Class<?>> buildGroupConversionMap(List<GroupConversionType> groupConversionTypes, String defaultPackage) {
        HashMap<Class<?>, Class<?>> groupConversionMap = CollectionHelper.newHashMap();
        for (GroupConversionType groupConversionType : groupConversionTypes) {
            Class<?> fromClass = ClassLoadingHelper.loadClass(groupConversionType.getFrom(), defaultPackage);
            Class<?> toClass = ClassLoadingHelper.loadClass(groupConversionType.getTo(), defaultPackage);
            groupConversionMap.put(fromClass, toClass);
        }
        return groupConversionMap;
    }
}

