/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.resteasy.api.validation.ResteasyConstraintViolation;

public class ViolationsContainer<T>
implements Serializable {
    private static final long serialVersionUID = -7895854137980651539L;
    private List<ResteasyConstraintViolation> fieldViolations = new ArrayList<ResteasyConstraintViolation>();
    private List<ResteasyConstraintViolation> propertyViolations = new ArrayList<ResteasyConstraintViolation>();
    private List<ResteasyConstraintViolation> classViolations = new ArrayList<ResteasyConstraintViolation>();
    private List<ResteasyConstraintViolation> parameterViolations = new ArrayList<ResteasyConstraintViolation>();
    private List<ResteasyConstraintViolation> returnValueViolations = new ArrayList<ResteasyConstraintViolation>();
    private Exception exception;

    public ViolationsContainer() {
    }

    public ViolationsContainer(Set<ResteasyConstraintViolation> set) {
        this.addViolations(set);
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public void addViolations(Set<? extends ResteasyConstraintViolation> set) {
        for (ResteasyConstraintViolation resteasyConstraintViolation : set) {
            switch (resteasyConstraintViolation.getConstraintType()) {
                case FIELD: {
                    this.fieldViolations.add(resteasyConstraintViolation);
                    break;
                }
                case PROPERTY: {
                    this.propertyViolations.add(resteasyConstraintViolation);
                    break;
                }
                case CLASS: {
                    this.classViolations.add(resteasyConstraintViolation);
                    break;
                }
                case PARAMETER: {
                    this.parameterViolations.add(resteasyConstraintViolation);
                    break;
                }
                case RETURN_VALUE: {
                    this.returnValueViolations.add(resteasyConstraintViolation);
                }
            }
        }
    }

    public void addFieldViolation(ResteasyConstraintViolation v) {
        this.fieldViolations.add(v);
    }

    public void addPropertyViolation(ResteasyConstraintViolation v) {
        this.propertyViolations.add(v);
    }

    public void addClassViolation(ResteasyConstraintViolation v) {
        this.classViolations.add(v);
    }

    public void addParameterViolation(ResteasyConstraintViolation v) {
        this.parameterViolations.add(v);
    }

    public void addReturnValueViolation(ResteasyConstraintViolation v) {
        this.returnValueViolations.add(v);
    }

    public List<ResteasyConstraintViolation> getFieldViolations() {
        return this.fieldViolations;
    }

    public List<ResteasyConstraintViolation> getPropertyViolations() {
        return this.propertyViolations;
    }

    public List<ResteasyConstraintViolation> getClassViolations() {
        return this.classViolations;
    }

    public List<ResteasyConstraintViolation> getParameterViolations() {
        return this.parameterViolations;
    }

    public List<ResteasyConstraintViolation> getReturnValueViolations() {
        return this.returnValueViolations;
    }

    public int size() {
        return this.fieldViolations.size() + this.propertyViolations.size() + this.classViolations.size() + this.parameterViolations.size() + this.returnValueViolations.size();
    }

    public String toString() {
        StringBuffer sb = this.setToStringBuffer(this.fieldViolations);
        sb.append(this.setToStringBuffer(this.propertyViolations));
        sb.append(this.setToStringBuffer(this.classViolations));
        sb.append(this.setToStringBuffer(this.parameterViolations));
        sb.append(this.setToStringBuffer(this.returnValueViolations));
        return sb.toString();
    }

    private StringBuffer setToStringBuffer(List<ResteasyConstraintViolation> set) {
        StringBuffer sb = new StringBuffer();
        Iterator<ResteasyConstraintViolation> it = set.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\r');
        }
        return sb;
    }
}

