/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.core.common.restful.impl;

import com.baidu.disconf.core.common.restful.RestfulMgr;
import com.baidu.disconf.core.common.restful.core.RemoteUrl;
import com.baidu.disconf.core.common.restful.retry.RetryStrategy;
import com.baidu.disconf.core.common.restful.type.FetchConfFile;
import com.baidu.disconf.core.common.restful.type.RestfulGet;
import com.baidu.disconf.core.common.utils.ClassLoaderUtil;
import com.baidu.disconf.core.common.utils.MyStringUtils;
import com.baidu.disconf.core.common.utils.OsUtil;
import com.baidu.disconf.core.common.utils.http.HttpClientUtil;
import java.io.File;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulMgrImpl
implements RestfulMgr {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RestfulMgrImpl.class);
    private RetryStrategy retryStrategy;

    public RestfulMgrImpl(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
        HttpClientUtil.init();
    }

    @Override
    public <T> T getJsonData(Class<T> clazz, RemoteUrl remoteUrl, int retryTimes, int retrySleepSeconds) throws Exception {
        for (URL url : remoteUrl.getUrls()) {
            RestfulGet<T> unreliableImpl = new RestfulGet<T>(clazz, url);
            try {
                Object t = this.retryStrategy.retry(unreliableImpl, retryTimes, retrySleepSeconds);
                return t;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    LOGGER.info("pass");
                }
            }
        }
        throw new Exception("cannot get: " + remoteUrl);
    }

    @Override
    public String downloadFromServer(RemoteUrl remoteUrl, String fileName, String localFileDir, String localFileDirTemp, String copy2TargetDirPath, boolean enableLocalDownloadDirInClassPath, int retryTimes, int retrySleepSeconds) throws Exception {
        String relativePathString;
        File localFile = null;
        try {
            File tmpFilePathUniqueFile = this.retryDownload(localFileDirTemp, fileName, remoteUrl, retryTimes, retrySleepSeconds);
            localFile = this.transfer2SpecifyDir(tmpFilePathUniqueFile, localFileDir, fileName, false);
            if (copy2TargetDirPath != null && (enableLocalDownloadDirInClassPath || !copy2TargetDirPath.equals(ClassLoaderUtil.getClassPath()))) {
                localFile = this.transfer2SpecifyDir(tmpFilePathUniqueFile, copy2TargetDirPath, fileName, true);
            }
            LOGGER.debug("Move to: " + localFile.getAbsolutePath());
        }
        catch (Exception e) {
            LOGGER.warn("download file failed, using previous download file.", (Throwable)e);
        }
        if (!localFile.exists()) {
            throw new Exception("target file cannot be found! " + fileName);
        }
        if (localFileDir != null && (relativePathString = OsUtil.getRelativePath(localFile, new File(localFileDir))) != null && new File(relativePathString).isFile()) {
            return relativePathString;
        }
        return localFile.getAbsolutePath();
    }

    @Override
    public void close() {
        HttpClientUtil.close();
    }

    private File retryDownload(String localFileDirTemp, String fileName, RemoteUrl remoteUrl, int retryTimes, int retrySleepSeconds) throws Exception {
        if (localFileDirTemp == null) {
            localFileDirTemp = "./disconf/download";
        }
        String tmpFilePath = OsUtil.pathJoin(localFileDirTemp, fileName);
        String tmpFilePathUnique = MyStringUtils.getRandomName(tmpFilePath);
        File tmpFilePathUniqueFile = new File(tmpFilePathUnique);
        this.retry4ConfDownload(remoteUrl, tmpFilePathUniqueFile, retryTimes, retrySleepSeconds);
        return tmpFilePathUniqueFile;
    }

    private File transfer2SpecifyDir(File srcFile, String copy2TargetDirPath, String fileName, boolean isMove) throws Exception {
        OsUtil.makeDirs(copy2TargetDirPath);
        File targetPath = new File(OsUtil.pathJoin(copy2TargetDirPath, fileName));
        if (targetPath != null) {
            OsUtil.transferFileAtom(srcFile, targetPath, isMove);
            return targetPath;
        }
        LOGGER.warn("targetPath is null, cannot transfer " + fileName + " to targetPath");
        return null;
    }

    private Object retry4ConfDownload(RemoteUrl remoteUrl, File localTmpFile, int retryTimes, int sleepSeconds) throws Exception {
        for (URL url : remoteUrl.getUrls()) {
            FetchConfFile unreliableImpl = new FetchConfFile(url, localTmpFile);
            try {
                return this.retryStrategy.retry(unreliableImpl, retryTimes, sleepSeconds);
            }
            catch (Exception e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    LOGGER.info("pass");
                }
            }
        }
        throw new Exception("download failed.");
    }
}

