/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.execution;

import com.dangdang.ddframe.job.api.JobConfiguration;
import com.dangdang.ddframe.job.internal.config.ConfigurationNode;
import com.dangdang.ddframe.job.internal.execution.ExecutionService;
import com.dangdang.ddframe.job.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;

public class ExecutionListenerManager
extends AbstractListenerManager {
    private final ExecutionService executionService;
    private final ConfigurationNode configNode;

    public ExecutionListenerManager(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        super(coordinatorRegistryCenter, jobConfiguration);
        this.executionService = new ExecutionService(coordinatorRegistryCenter, jobConfiguration);
        this.configNode = new ConfigurationNode(jobConfiguration.getJobName());
    }

    @Override
    public void start() {
        this.addDataListener(new MonitorExecutionChangedJobListener());
    }

    class MonitorExecutionChangedJobListener
    extends AbstractJobListener {
        MonitorExecutionChangedJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (ExecutionListenerManager.this.configNode.isMonitorExecutionPath(path) && TreeCacheEvent.Type.NODE_UPDATED == event.getType() && !Boolean.valueOf(new String(event.getData().getData())).booleanValue()) {
                ExecutionListenerManager.this.executionService.removeExecutionInfo();
            }
        }
    }
}

