/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.job.dataflow;

import com.dangdang.ddframe.job.api.DataFlowElasticJob;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.api.JobExecutionSingleShardingContext;
import com.dangdang.ddframe.job.internal.job.AbstractElasticJob;
import com.dangdang.ddframe.job.internal.job.AbstractJobExecutionShardingContext;
import com.dangdang.ddframe.job.internal.job.dataflow.DataFlowType;
import com.google.common.collect.Lists;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections.CollectionUtils;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataFlowElasticJob<T, C extends AbstractJobExecutionShardingContext>
extends AbstractElasticJob
implements DataFlowElasticJob<T, C> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataFlowElasticJob.class);
    private final ExecutorService executorService = this.getExecutorService();
    private final DataFlowType dataFlowType = this.getDataFlowType();

    private DataFlowType getDataFlowType() {
        ParameterizedType parameterizedType;
        Class<?> target = this.getClass();
        while (true) {
            if (!(target.getGenericSuperclass() instanceof ParameterizedType)) {
                target = target.getSuperclass();
                continue;
            }
            parameterizedType = (ParameterizedType)target.getGenericSuperclass();
            if (2 == parameterizedType.getActualTypeArguments().length) break;
            target = target.getSuperclass();
        }
        Type type = parameterizedType.getActualTypeArguments()[1];
        if (JobExecutionMultipleShardingContext.class == type) {
            return DataFlowType.THROUGHPUT;
        }
        if (JobExecutionSingleShardingContext.class == type) {
            return DataFlowType.SEQUENCE;
        }
        throw new UnsupportedOperationException(String.format("Cannot support %s", type));
    }

    @Override
    protected final void executeJob(JobExecutionMultipleShardingContext shardingContext) {
        if (DataFlowType.THROUGHPUT == this.dataFlowType) {
            if (this.isStreamingProcess()) {
                this.executeThroughputStreamingJob(shardingContext);
            } else {
                this.executeThroughputOneOffJob(shardingContext);
            }
        } else if (DataFlowType.SEQUENCE == this.dataFlowType) {
            if (this.isStreamingProcess()) {
                this.executeSequenceStreamingJob(shardingContext);
            } else {
                this.executeSequenceOneOffJob(shardingContext);
            }
        }
    }

    private void executeThroughputStreamingJob(JobExecutionMultipleShardingContext shardingContext) {
        List<T> data = this.fetchDataForThroughput(shardingContext);
        while (!CollectionUtils.isEmpty(data)) {
            this.processDataForThroughput(shardingContext, data);
            if (!this.getJobFacade().isEligibleForJobRunning()) break;
            data = this.fetchDataForThroughput(shardingContext);
        }
    }

    private void executeThroughputOneOffJob(JobExecutionMultipleShardingContext shardingContext) {
        List<T> data = this.fetchDataForThroughput(shardingContext);
        if (!CollectionUtils.isEmpty(data)) {
            this.processDataForThroughput(shardingContext, data);
        }
    }

    private void executeSequenceStreamingJob(JobExecutionMultipleShardingContext shardingContext) {
        Map<Integer, List<T>> data = this.fetchDataForSequence(shardingContext);
        while (!data.isEmpty()) {
            this.processDataForSequence(shardingContext, data);
            if (!this.getJobFacade().isEligibleForJobRunning()) break;
            data = this.fetchDataForSequence(shardingContext);
        }
    }

    private void executeSequenceOneOffJob(JobExecutionMultipleShardingContext shardingContext) {
        Map<Integer, List<T>> data = this.fetchDataForSequence(shardingContext);
        if (!data.isEmpty()) {
            this.processDataForSequence(shardingContext, data);
        }
    }

    private List<T> fetchDataForThroughput(JobExecutionMultipleShardingContext shardingContext) {
        List result = this.fetchData(shardingContext);
        log.trace("Elastic job: fetch data size: {}.", (Object)(result != null ? result.size() : 0));
        return result;
    }

    private void processDataForThroughput(final JobExecutionMultipleShardingContext shardingContext, List<T> data) {
        int threadCount = this.getJobFacade().getConcurrentDataProcessThreadCount();
        if (threadCount <= 1 || data.size() <= threadCount) {
            this.processDataWithStatistics(shardingContext, data);
            return;
        }
        List splitData = Lists.partition(data, (int)(data.size() / threadCount));
        final CountDownLatch latch = new CountDownLatch(splitData.size());
        for (final List each : splitData) {
            this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        AbstractDataFlowElasticJob.this.processDataWithStatistics(shardingContext, each);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        this.latchAwait(latch);
    }

    private Map<Integer, List<T>> fetchDataForSequence(final JobExecutionMultipleShardingContext shardingContext) {
        List<Integer> items = shardingContext.getShardingItems();
        final ConcurrentHashMap<Integer, List<T>> result = new ConcurrentHashMap<Integer, List<T>>(items.size());
        final CountDownLatch latch = new CountDownLatch(items.size());
        for (final int each : items) {
            this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        List data = AbstractDataFlowElasticJob.this.fetchData(shardingContext.createJobExecutionSingleShardingContext(each));
                        if (null != data && !data.isEmpty()) {
                            result.put(each, data);
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        this.latchAwait(latch);
        log.trace("Elastic job: fetch data size: {}.", (Object)result.size());
        return result;
    }

    private void processDataForSequence(final JobExecutionMultipleShardingContext shardingContext, Map<Integer, List<T>> data) {
        final CountDownLatch latch = new CountDownLatch(data.size());
        for (final Map.Entry<Integer, List<T>> each : data.entrySet()) {
            this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        AbstractDataFlowElasticJob.this.processDataWithStatistics(shardingContext.createJobExecutionSingleShardingContext((Integer)each.getKey()), (List)each.getValue());
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        this.latchAwait(latch);
    }

    protected abstract void processDataWithStatistics(C var1, List<T> var2);

    @Override
    public final void updateOffset(int item, String offset) {
        this.getJobFacade().updateOffset(item, offset);
    }

    @Override
    public ExecutorService getExecutorService() {
        return Executors.newCachedThreadPool();
    }

    @Override
    public void handleJobExecutionException(JobExecutionException jobExecutionException) throws JobExecutionException {
        log.error("Elastic job: exception occur in job processing...", jobExecutionException.getCause());
    }

    private void latchAwait(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

