/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.sharding;

import com.dangdang.ddframe.job.api.JobConfiguration;
import com.dangdang.ddframe.job.internal.config.ConfigurationNode;
import com.dangdang.ddframe.job.internal.execution.ExecutionService;
import com.dangdang.ddframe.job.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.job.internal.server.ServerNode;
import com.dangdang.ddframe.job.internal.sharding.ShardingService;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;

public class ShardingListenerManager
extends AbstractListenerManager {
    private final ShardingService shardingService;
    private final ExecutionService executionService;
    private final ConfigurationNode configurationNode;
    private final ServerNode serverNode;

    public ShardingListenerManager(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        super(coordinatorRegistryCenter, jobConfiguration);
        this.shardingService = new ShardingService(coordinatorRegistryCenter, jobConfiguration);
        this.executionService = new ExecutionService(coordinatorRegistryCenter, jobConfiguration);
        this.configurationNode = new ConfigurationNode(jobConfiguration.getJobName());
        this.serverNode = new ServerNode(jobConfiguration.getJobName());
    }

    @Override
    public void start() {
        this.addDataListener(new ShardingTotalCountChangedJobListener());
        this.addDataListener(new ListenServersChangedJobListener());
    }

    class ListenServersChangedJobListener
    extends AbstractJobListener {
        ListenServersChangedJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (this.isServersCrashed(event, path) || ShardingListenerManager.this.serverNode.isServerDisabledPath(path)) {
                ShardingListenerManager.this.shardingService.setReshardingFlag();
            }
        }

        private boolean isServersCrashed(TreeCacheEvent event, String path) {
            return ShardingListenerManager.this.serverNode.isServerStatusPath(path) && TreeCacheEvent.Type.NODE_UPDATED != event.getType();
        }
    }

    class ShardingTotalCountChangedJobListener
    extends AbstractJobListener {
        ShardingTotalCountChangedJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (ShardingListenerManager.this.configurationNode.isShardingTotalCountPath(path)) {
                ShardingListenerManager.this.shardingService.setReshardingFlag();
                ShardingListenerManager.this.executionService.setNeedFixExecutionInfoFlag();
            }
        }
    }
}

