/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.statistics;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class ProcessCountStatistics {
    private static ConcurrentMap<String, AtomicInteger> processSuccessCount = new ConcurrentHashMap<String, AtomicInteger>();
    private static ConcurrentMap<String, AtomicInteger> processFailureCount = new ConcurrentHashMap<String, AtomicInteger>();

    public static void incrementProcessSuccessCount(String jobName) {
        ProcessCountStatistics.incrementProcessCount(jobName, processSuccessCount);
    }

    public static void incrementProcessSuccessCount(String jobName, int successCount) {
        ProcessCountStatistics.incrementProcessCount(jobName, successCount, processSuccessCount);
    }

    public static void incrementProcessFailureCount(String jobName) {
        ProcessCountStatistics.incrementProcessCount(jobName, processFailureCount);
    }

    public static void incrementProcessFailureCount(String jobName, int failureCount) {
        ProcessCountStatistics.incrementProcessCount(jobName, failureCount, processFailureCount);
    }

    private static void incrementProcessCount(String jobName, ConcurrentMap<String, AtomicInteger> processCountMap) {
        processCountMap.putIfAbsent(jobName, new AtomicInteger(0));
        ((AtomicInteger)processCountMap.get(jobName)).incrementAndGet();
    }

    private static void incrementProcessCount(String jobName, int count, ConcurrentMap<String, AtomicInteger> processCountMap) {
        processCountMap.putIfAbsent(jobName, new AtomicInteger(0));
        ((AtomicInteger)processCountMap.get(jobName)).addAndGet(count);
    }

    public static int getProcessSuccessCount(String jobName) {
        return null == processSuccessCount.get(jobName) ? 0 : ((AtomicInteger)processSuccessCount.get(jobName)).get();
    }

    public static int getProcessFailureCount(String jobName) {
        return null == processFailureCount.get(jobName) ? 0 : ((AtomicInteger)processFailureCount.get(jobName)).get();
    }

    public static void reset(String jobName) {
        if (processSuccessCount.containsKey(jobName)) {
            ((AtomicInteger)processSuccessCount.get(jobName)).set(0);
        }
        if (processFailureCount.containsKey(jobName)) {
            ((AtomicInteger)processFailureCount.get(jobName)).set(0);
        }
    }

    private ProcessCountStatistics() {
    }
}

