/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.storage;

import com.dangdang.ddframe.job.api.JobConfiguration;
import com.dangdang.ddframe.job.exception.JobException;
import com.dangdang.ddframe.job.internal.storage.JobNodePath;
import com.dangdang.ddframe.job.internal.storage.LeaderExecutionCallback;
import com.dangdang.ddframe.job.internal.storage.TransactionExecutionCallback;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.reg.exception.RegExceptionHandler;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.api.transaction.CuratorTransactionFinal;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.state.ConnectionStateListener;

public class JobNodeStorage {
    private final CoordinatorRegistryCenter coordinatorRegistryCenter;
    private final JobConfiguration jobConfiguration;
    private final JobNodePath jobNodePath;

    public JobNodeStorage(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        this.coordinatorRegistryCenter = coordinatorRegistryCenter;
        this.jobConfiguration = jobConfiguration;
        this.jobNodePath = new JobNodePath(jobConfiguration.getJobName());
    }

    public boolean isJobNodeExisted(String node) {
        return this.coordinatorRegistryCenter.isExisted(this.jobNodePath.getFullPath(node));
    }

    public String getJobNodeData(String node) {
        return this.coordinatorRegistryCenter.get(this.jobNodePath.getFullPath(node));
    }

    public String getJobNodeDataDirectly(String node) {
        return this.coordinatorRegistryCenter.getDirectly(this.jobNodePath.getFullPath(node));
    }

    public List<String> getJobNodeChildrenKeys(String node) {
        return this.coordinatorRegistryCenter.getChildrenKeys(this.jobNodePath.getFullPath(node));
    }

    public void createJobNodeIfNeeded(String node) {
        if (!this.isJobNodeExisted(node)) {
            this.coordinatorRegistryCenter.persist(this.jobNodePath.getFullPath(node), "");
        }
    }

    public void removeJobNodeIfExisted(String node) {
        if (this.isJobNodeExisted(node)) {
            this.coordinatorRegistryCenter.remove(this.jobNodePath.getFullPath(node));
        }
    }

    public void fillJobNodeIfNullOrOverwrite(String node, Object value) {
        if (!this.isJobNodeExisted(node) || this.jobConfiguration.isOverwrite() && !value.toString().equals(this.getJobNodeDataDirectly(node))) {
            this.coordinatorRegistryCenter.persist(this.jobNodePath.getFullPath(node), value.toString());
        }
    }

    public void fillEphemeralJobNode(String node, Object value) {
        this.coordinatorRegistryCenter.persistEphemeral(this.jobNodePath.getFullPath(node), value.toString());
    }

    public void updateJobNode(String node, Object value) {
        this.coordinatorRegistryCenter.update(this.jobNodePath.getFullPath(node), value.toString());
    }

    public void replaceJobNode(String node, Object value) {
        this.coordinatorRegistryCenter.persist(this.jobNodePath.getFullPath(node), value.toString());
    }

    public void executeInTransaction(TransactionExecutionCallback callback) {
        try {
            CuratorTransactionFinal curatorTransactionFinal = ((CuratorTransactionBridge)this.getClient().inTransaction().check().forPath("/")).and();
            callback.execute(curatorTransactionFinal);
            curatorTransactionFinal.commit();
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    public void executeInLeader(String latchNode, LeaderExecutionCallback callback) {
        try (LeaderLatch latch = new LeaderLatch(this.getClient(), this.jobNodePath.getFullPath(latchNode));){
            latch.start();
            latch.await();
            callback.execute();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void handleException(Exception ex) {
        if (!(ex instanceof InterruptedException)) {
            throw new JobException(ex);
        }
        Thread.currentThread().interrupt();
    }

    public void addConnectionStateListener(ConnectionStateListener listener) {
        this.getClient().getConnectionStateListenable().addListener((Object)listener);
    }

    private CuratorFramework getClient() {
        return (CuratorFramework)this.coordinatorRegistryCenter.getRawClient();
    }

    public void addDataListener(TreeCacheListener listener) {
        TreeCache cache = (TreeCache)this.coordinatorRegistryCenter.getRawCache("/" + this.jobConfiguration.getJobName());
        cache.getListenable().addListener((Object)listener);
    }

    public long getRegistryCenterTime() {
        return this.coordinatorRegistryCenter.getRegistryCenterTime(this.jobNodePath.getFullPath("systemTime/current"));
    }

    public JobConfiguration getJobConfiguration() {
        return this.jobConfiguration;
    }
}

