/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.reg.zookeeper;

import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.reg.exception.LocalPropertiesFileNotFoundException;
import com.dangdang.ddframe.reg.exception.RegExceptionHandler;
import com.dangdang.ddframe.reg.zookeeper.NestedZookeeperServers;
import com.dangdang.ddframe.reg.zookeeper.ZookeeperConfiguration;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperRegistryCenter
implements CoordinatorRegistryCenter {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperRegistryCenter.class);
    private ZookeeperConfiguration zkConfig;
    private final Map<String, TreeCache> caches = new HashMap<String, TreeCache>();
    private CuratorFramework client;

    public ZookeeperRegistryCenter(ZookeeperConfiguration zkConfig) {
        this.zkConfig = zkConfig;
    }

    @Override
    public void init() {
        if (this.zkConfig.isUseNestedZookeeper()) {
            NestedZookeeperServers.getInstance().startServerIfNotStarted(this.zkConfig.getNestedPort(), this.zkConfig.getNestedDataDir());
        }
        log.debug("Elastic job: zookeeper registry center init, server lists is: {}.", (Object)this.zkConfig.getServerLists());
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(this.zkConfig.getServerLists()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(this.zkConfig.getBaseSleepTimeMilliseconds(), this.zkConfig.getMaxRetries(), this.zkConfig.getMaxSleepTimeMilliseconds())).namespace(this.zkConfig.getNamespace());
        if (0 != this.zkConfig.getSessionTimeoutMilliseconds()) {
            builder.sessionTimeoutMs(this.zkConfig.getSessionTimeoutMilliseconds());
        }
        if (0 != this.zkConfig.getConnectionTimeoutMilliseconds()) {
            builder.connectionTimeoutMs(this.zkConfig.getConnectionTimeoutMilliseconds());
        }
        if (!Strings.isNullOrEmpty((String)this.zkConfig.getDigest())) {
            builder.authorization("digest", this.zkConfig.getDigest().getBytes(Charset.forName("UTF-8"))).aclProvider(new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }

                public List<ACL> getAclForPath(String path) {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }
            });
        }
        this.client = builder.build();
        this.client.start();
        try {
            this.client.blockUntilConnected();
            if (!Strings.isNullOrEmpty((String)this.zkConfig.getLocalPropertiesPath())) {
                this.fillData();
            }
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    private void fillData() throws Exception {
        for (Map.Entry<Object, Object> entry : this.loadLocalProperties().entrySet()) {
            String key = entry.getKey().toString();
            byte[] value = entry.getValue().toString().getBytes(Charset.forName("UTF-8"));
            if (null == this.client.checkExists().forPath(key)) {
                this.client.create().creatingParentsIfNeeded().forPath(key, value);
                continue;
            }
            if (!this.zkConfig.isOverwrite() && 0 != ((byte[])this.client.getData().forPath(key)).length) continue;
            this.client.setData().forPath(key, value);
        }
    }

    private Properties loadLocalProperties() {
        Properties result = new Properties();
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.zkConfig.getLocalPropertiesPath());){
            if (null == input) {
                throw new LocalPropertiesFileNotFoundException(this.zkConfig.getLocalPropertiesPath());
            }
            result.load(input);
        }
        catch (IOException ex) {
            throw new LocalPropertiesFileNotFoundException(ex);
        }
        return result;
    }

    @Override
    public void close() {
        for (Map.Entry<String, TreeCache> each : this.caches.entrySet()) {
            each.getValue().close();
        }
        this.waitForCacheClose();
        CloseableUtils.closeQuietly((Closeable)this.client);
        if (this.zkConfig.isUseNestedZookeeper()) {
            NestedZookeeperServers.getInstance().closeServer(this.zkConfig.getNestedPort());
        }
    }

    private void waitForCacheClose() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public String get(String key) {
        TreeCache cache = this.findTreeCache(key);
        if (null == cache) {
            return this.getDirectly(key);
        }
        ChildData resultInCache = cache.getCurrentData(key);
        if (null != resultInCache) {
            return null == resultInCache.getData() ? null : new String(resultInCache.getData(), Charset.forName("UTF-8"));
        }
        return this.getDirectly(key);
    }

    private TreeCache findTreeCache(String key) {
        for (Map.Entry<String, TreeCache> entry : this.caches.entrySet()) {
            if (!key.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public String getDirectly(String key) {
        try {
            return new String((byte[])this.client.getData().forPath(key), Charset.forName("UTF-8"));
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
            return null;
        }
    }

    @Override
    public List<String> getChildrenKeys(String key) {
        try {
            List result = (List)this.client.getChildren().forPath(key);
            Collections.sort(result, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o2.compareTo(o1);
                }
            });
            return result;
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
            return Collections.emptyList();
        }
    }

    @Override
    public boolean isExisted(String key) {
        try {
            return null != this.client.checkExists().forPath(key);
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
            return false;
        }
    }

    @Override
    public void persist(String key, String value) {
        try {
            if (!this.isExisted(key)) {
                ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(key, value.getBytes());
            } else {
                this.update(key, value);
            }
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    @Override
    public void update(String key, String value) {
        try {
            ((CuratorTransactionBridge)((CuratorTransactionBridge)this.client.inTransaction().check().forPath(key)).and().setData().forPath(key, value.getBytes(Charset.forName("UTF-8")))).and().commit();
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    @Override
    public void persistEphemeral(String key, String value) {
        try {
            if (this.isExisted(key)) {
                this.client.delete().deletingChildrenIfNeeded().forPath(key);
            }
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(key, value.getBytes(Charset.forName("UTF-8")));
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    @Override
    public void persistEphemeralSequential(String key) {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(key);
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    @Override
    public void remove(String key) {
        try {
            this.client.delete().deletingChildrenIfNeeded().forPath(key);
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    @Override
    public long getRegistryCenterTime(String key) {
        long result = 0L;
        try {
            String path = (String)((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(key);
            result = ((Stat)this.client.checkExists().forPath(path)).getCtime();
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
        Preconditions.checkState((0L != result ? 1 : 0) != 0, (Object)"Cannot get registry center time.");
        return result;
    }

    @Override
    public Object getRawClient() {
        return this.client;
    }

    @Override
    public void addCacheData(String cachePath) {
        TreeCache cache = new TreeCache(this.client, cachePath);
        try {
            cache.start();
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
        this.caches.put(cachePath + "/", cache);
    }

    @Override
    public Object getRawCache(String cachePath) {
        return this.caches.get(cachePath + "/");
    }

    protected ZookeeperConfiguration getZkConfig() {
        return this.zkConfig;
    }
}

