/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.addons.properties;

import com.baidu.disconf.client.DisconfMgr;
import com.baidu.disconf.client.addons.properties.IReloadablePropertiesListener;
import com.baidu.disconf.client.addons.properties.ReconfigurableBean;
import com.baidu.disconf.client.addons.properties.ReloadConfigurationMonitor;
import com.baidu.disconf.client.addons.properties.ReloadablePropertiesBase;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ReloadablePropertiesFactoryBean
extends PropertiesFactoryBean
implements DisposableBean,
ApplicationContextAware {
    private static ApplicationContext applicationContext;
    protected static final Logger log;
    private Resource[] locations;
    private long[] lastModified;
    private List<IReloadablePropertiesListener> preListeners;
    private ReloadablePropertiesBase reloadableProperties;

    public void setLocation(String fileNames) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(fileNames);
        this.setLocations(list);
    }

    public void setLocations(List<String> fileNames) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String filename : fileNames) {
            filename = filename.trim();
            String realFileName = this.getFileName(filename);
            DisconfMgr.getInstance().reloadableScan(realFileName);
            String ext = FilenameUtils.getExtension((String)filename);
            if (!ext.equals("properties")) continue;
            PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
            try {
                Resource[] resourceList;
                for (Resource resource : resourceList = pathMatchingResourcePatternResolver.getResources(filename)) {
                    resources.add(resource);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.locations = resources.toArray(new Resource[resources.size()]);
        this.lastModified = new long[this.locations.length];
        super.setLocations(this.locations);
    }

    private String getFileName(String fileName) {
        if (fileName != null) {
            int index = fileName.indexOf(58);
            if (index < 0) {
                return fileName;
            }
            if ((index = (fileName = fileName.substring(index + 1)).lastIndexOf(47)) < 0) {
                return fileName;
            }
            return fileName.substring(index + 1);
        }
        return null;
    }

    protected Resource[] getLocations() {
        return this.locations;
    }

    public void setListeners(List listeners) {
        this.preListeners = new ArrayList<IReloadablePropertiesListener>();
        for (Object o : listeners) {
            this.preListeners.add((IReloadablePropertiesListener)o);
        }
    }

    protected Properties createProperties() throws IOException {
        return (Properties)this.createMyInstance();
    }

    protected Object createMyInstance() throws IOException {
        if (!this.isSingleton()) {
            throw new RuntimeException("ReloadablePropertiesFactoryBean only works as singleton");
        }
        this.reloadableProperties = new ReloadablePropertiesImpl();
        if (this.preListeners != null) {
            this.reloadableProperties.setListeners(this.preListeners);
        }
        this.reload(true);
        ReloadConfigurationMonitor.addReconfigurableBean((ReconfigurableBean)((Object)this.reloadableProperties));
        return this.reloadableProperties;
    }

    public void destroy() throws Exception {
        this.reloadableProperties = null;
    }

    protected void reload(boolean forceReload) throws IOException {
        boolean reload = forceReload;
        for (int i = 0; i < this.locations.length; ++i) {
            File file;
            Resource location = this.locations[i];
            try {
                file = location.getFile();
            }
            catch (IOException e) {
                log.warn(e.toString());
                continue;
            }
            try {
                long l = file.lastModified();
                if (l <= this.lastModified[i]) continue;
                this.lastModified[i] = l;
                reload = true;
                continue;
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("can't determine modification time of " + file + " for " + location, (Throwable)e);
            }
        }
        if (reload) {
            this.doReload();
        }
    }

    private void doReload() throws IOException {
        this.reloadableProperties.setProperties(this.mergeProperties());
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ReloadablePropertiesFactoryBean.applicationContext = applicationContext;
    }

    static {
        log = LoggerFactory.getLogger(ReloadablePropertiesFactoryBean.class);
    }

    class ReloadablePropertiesImpl
    extends ReloadablePropertiesBase
    implements ReconfigurableBean {
        ReloadablePropertiesImpl() {
        }

        @Override
        public void reloadConfiguration() throws Exception {
            ReloadablePropertiesFactoryBean.this.reload(false);
        }
    }
}

