/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.scan.inner.common;

import com.baidu.disconf.client.common.annotations.DisconfFile;
import com.baidu.disconf.client.common.constants.SupportFileTypeEnum;
import com.baidu.disconf.client.common.update.IDisconfUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanVerify {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ScanVerify.class);

    public static boolean hasIDisconfUpdate(Class<?> disconfUpdateServiceClass) {
        Class<?>[] interfaceClasses = disconfUpdateServiceClass.getInterfaces();
        boolean hasInterface = false;
        for (Class<?> infClass : interfaceClasses) {
            if (!infClass.equals(IDisconfUpdate.class)) continue;
            hasInterface = true;
        }
        if (!hasInterface) {
            LOGGER.error("Your class " + disconfUpdateServiceClass.toString() + " should implement interface: " + IDisconfUpdate.class.toString());
            return false;
        }
        return true;
    }

    public static boolean isDisconfFileTypeRight(DisconfFile disconfFile) {
        String fileName = disconfFile.filename();
        SupportFileTypeEnum supportFileTypeEnum = SupportFileTypeEnum.getByFileName(fileName);
        if (supportFileTypeEnum == null) {
            LOGGER.error("now we only support this type of conf: " + disconfFile.toString());
            return false;
        }
        return true;
    }
}

