/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.watch.impl;

import com.baidu.disconf.client.common.model.DisConfCommonModel;
import com.baidu.disconf.client.config.inner.DisClientComConfig;
import com.baidu.disconf.client.core.processor.DisconfCoreProcessor;
import com.baidu.disconf.client.watch.WatchMgr;
import com.baidu.disconf.client.watch.inner.DisconfSysUpdateCallback;
import com.baidu.disconf.client.watch.inner.NodeWatcher;
import com.baidu.disconf.core.common.constants.DisConfigTypeEnum;
import com.baidu.disconf.core.common.path.ZooPathMgr;
import com.baidu.disconf.core.common.utils.ZooUtils;
import com.baidu.disconf.core.common.zookeeper.ZookeeperMgr;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchMgrImpl
implements WatchMgr {
    protected static final Logger LOGGER = LoggerFactory.getLogger(WatchMgrImpl.class);
    private String zooUrlPrefix;
    private boolean debug;

    @Override
    public void init(String hosts, String zooUrlPrefix, boolean debug) throws Exception {
        this.zooUrlPrefix = zooUrlPrefix;
        this.debug = debug;
        ZookeeperMgr.getInstance().init(hosts, zooUrlPrefix, debug);
    }

    private String makeMonitorPath(DisConfigTypeEnum disConfigTypeEnum, DisConfCommonModel disConfCommonModel, String key, String value) throws Exception {
        String monitorPath;
        String clientRootZooPath = ZooPathMgr.getZooBaseUrl((String)this.zooUrlPrefix, (String)disConfCommonModel.getApp(), (String)disConfCommonModel.getEnv(), (String)disConfCommonModel.getVersion());
        ZookeeperMgr.getInstance().makeDir(clientRootZooPath, ZooUtils.getIp());
        if (disConfigTypeEnum.equals((Object)DisConfigTypeEnum.FILE)) {
            String clientDisconfFileZooPath = ZooPathMgr.getFileZooPath((String)clientRootZooPath);
            this.makePath(clientDisconfFileZooPath, ZooUtils.getIp());
            monitorPath = ZooPathMgr.joinPath((String)clientDisconfFileZooPath, (String)key);
        } else {
            String clientDisconfItemZooPath = ZooPathMgr.getItemZooPath((String)clientRootZooPath);
            this.makePath(clientDisconfItemZooPath, ZooUtils.getIp());
            monitorPath = ZooPathMgr.joinPath((String)clientDisconfItemZooPath, (String)key);
        }
        this.makePath(monitorPath, "");
        this.makeTempChildPath(monitorPath, value);
        return monitorPath;
    }

    private void makePath(String path, String data) {
        ZookeeperMgr.getInstance().makeDir(path, data);
    }

    private void makeTempChildPath(String path, String data) {
        String finerPrint = DisClientComConfig.getInstance().getInstanceFingerprint();
        String mainTypeFullStr = path + "/" + finerPrint;
        try {
            ZookeeperMgr.getInstance().createEphemeralNode(mainTypeFullStr, data, CreateMode.EPHEMERAL);
        }
        catch (Exception e) {
            LOGGER.error("cannot create: " + mainTypeFullStr + "\t" + e.toString());
        }
    }

    @Override
    public void watchPath(DisconfCoreProcessor disconfCoreMgr, DisConfCommonModel disConfCommonModel, String keyName, DisConfigTypeEnum disConfigTypeEnum, String value) throws Exception {
        String monitorPath = this.makeMonitorPath(disConfigTypeEnum, disConfCommonModel, keyName, value);
        NodeWatcher nodeWatcher = new NodeWatcher(disconfCoreMgr, monitorPath, keyName, disConfigTypeEnum, new DisconfSysUpdateCallback(), this.debug);
        nodeWatcher.monitorMaster();
    }

    @Override
    public void release() {
        try {
            ZookeeperMgr.getInstance().release();
        }
        catch (InterruptedException e) {
            LOGGER.error(e.toString());
        }
    }
}

