package cn.com.duiba.kjj.center.api.dto.user;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-11-11 19:23
 * 用户版本dto
 */
@Data
public class UserVersionDto implements Serializable {

    private static final long serialVersionUID = 7107411673397892915L;


    /**
     * 主键
     * not null default = null
     */
    private Long id;

    /**
     * 对应tb_users的id字段
     * not null default = null
     */
    private Long userId;

    /**
     * 对应tb_seller的id字段
     */
    private Long sellerId;

    /**
     * 启用标识 0:未启用 1:启用
     */
    private Integer openType;

    /**
     * 用户版本 1:通用版 2:保险专业版
     * not null default = null
     */
    private Integer userVersion;

    /**
     * vip开始时间
     * not null default = null
     */
    private Date vipBeginTime;

    /**
     * vip结束时间
     * not null default = null
     */
    private Date vipEndTime;
}
