package cn.com.duiba.kjj.center.api.enums.content;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-11-11 15:42
 * 素材类型枚举
 */
@Getter
@AllArgsConstructor
public enum ContentTypeEnum {

    /**
     * 内容类型
     */
    ARTICLE("article", "文章"),
    ACTIVITY("activity", "活动"),
    DAILY("daily", "早报"),
    POSTER("poster", "海报"),
    AFTERNOON("afternoon", "午后话题"),
    EVENING("evening", "晚安心语"),
    GAME_LOTTERY("game_lottery", "抽奖工具"),
    GAME_TEMPLATE("game_template", "抽奖模板"),
    GAME_ANSWER("game_answer", "趣味测试"),
    GAME_ANIMATION("game_animation", "动画"),
    GREETING_CARD("greeting_card", "节日贺卡"),
    INVITATION_LETTER("invitation_letter", "邀请函"),
    MATERIAL_CONTENT("material_content", "发圈素材"),
    HONORARY_ALBUM("honorary_album", "荣誉相册"),
    POSTER_TEMPLATE("poster_template","海报模版"),

    /**
     * 新版名片，不兼容老版。设立新类型
     */
    SELLER_CARD("card", "名片分享"),
    OUTER_MARKET("outer_market", "腰封自定义链接"),
    OUTER_EXCLUSIVE("outer_exclusive", "专区自定义链接"),
    WEEKLY_PUBLICATION("weekly_publication", "代理人周报"),
    NETWORK_LINK("network_link", "全网链接"),
    VIDEO("video", "视频"),
    DATAGRAM("datagram", "资料包"),
    DATAGRAM_ARTICLE("datagram_article", "资料包文章"),
    TIME_LOTTERY("time_lottery", "定时抽奖"),
    ;

    /**
     * 素材类型码
     */
    private final String code;

    /**
     * 描述
     */
    private final String desc;



}
