package cn.com.duiba.kjj.center.api.enums.push;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2019/7/12 12:56 PM
 */
@Getter
@AllArgsConstructor
public enum PushMessageTypeEnum {

    KEFU_TEXT(1, "客服文本消息"),
    KEFU_PIC_TEXT(2, "客服图文消息"),
    TEMPLATE(3, "模板消息"),
    KEFU_MINI(4, "公众号客服小程序卡片"),
    KEFU_PIC(5, "公众号图片消息"),
    TEMPLATE_MP(10, "小程序模板消息"),
    SUBSCRIBE_MP(11, "小程序订阅消息"),
    KEFU_PIC_MP(12, "小程序客服图片消息"),
    KEFU_PIC_TEXT_MP(13, "小程序客服图文消息"),
    ;

    /**
     * 推送消息类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;
}
