package cn.com.duiba.kjj.center.api.remoteservice.clock;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-11-12 09:30
 * 180天打卡
 */
@AdvancedFeignClient
public interface RemoteSellerClockInProgressService {

    /**
     * 根据代理人ID和打卡类型查询条数（未删除）
     *
     * @param sellerId    代理人ID
     * @param clockInType 打卡类型
     * @see cn.com.duiba.kjj.center.api.enums.clock.ClockInTypeEnum
     * @return 条数
     */
    int countBySellerIdAndClockType(Long sellerId, Integer clockInType);
}
