package cn.com.duiba.kjj.center.api.remoteservice.promotion;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjj.center.api.dto.promotion.PromotionCodeDto;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-11-10 15:37
 * 用户优惠码 rpc service
 */
@AdvancedFeignClient
public interface RemotePromotionCodeService {

    /**
     * 获取首个加锁或已经使用的优惠码
     * @param userId 用户id
     * @param batchId 优惠码批次id
     * @return 首个加锁或已经使用的优惠码
     */
    PromotionCodeDto findFirstLockOrUsed(Long userId, Long batchId);

    /**
     * 分配优惠码
     * @param promId 优惠码批次id
     * @param sellerId 销售id
     * @param userId 用户id
     * @return 优惠码
     */
    String lockPromotionCode(Long promId, Long sellerId, Long userId);
}
