package cn.com.duiba.kjj.center.api.dto.process;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 审批流程表
 * @author kjj mybatis generator 
 * @date 2021-11-24
 */
@Data
public class ProcessFlowDto implements Serializable {
     
    private static final long serialVersionUID = 1637720479854303L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 流程类型：2-用户退款审批
     * @see cn.com.duiba.kjj.center.api.enums.process.ProcessFlowTypeEnum
     */
    private Integer flowType;

    /**
     * 业务ID，退款时为tb_order_refund.id
     */
    private Long outId;

    /**
     * 角色类型：1-销售主管 2-财务，3-退款财务
     * @see cn.com.duiba.kjj.center.api.enums.process.ProcessRoleTypeEnum
     */
    private Integer checkerRoleType;

    /**
     * 审批人ID，tb_process_role.id
     */
    private String checkId;

    /**
     * 审批人名称， tb_process_role.role_biz_name
     */
    private String checkName;

    /**
     * 审批说明
     */
    private String checkRemark;

    /**
     * 审批状态 0:待审批 1:审批通过 2:审批拒绝
     * @see cn.com.duiba.kjj.center.api.enums.process.ProcessCheckStatusEnum
     */
    private Integer checkStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 附件oss地址
     */
    private String accessory;
}