package cn.com.duiba.kjj.center.api.dto.seller;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 销售员账户表
 * @author kjj mybatis generator 
 * @date 2021-11-16
 */
@Data
public class SellerAccountDto implements Serializable {
     
    private static final long serialVersionUID = 16370544636205129L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 销售员id
     */
    private Long sellerId;

    /**
     * 累计推广收益(分)
     */
    private Integer totalPromotionEarnings;

    /**
     * 余额(分)
     */
    private Integer balance;

    /**
     * 待结算余额(分)
     */
    private Integer settleMoney;

    /**
     * 最近一次提现操作时间
     */
    private Date withdrawData;

    /**
     * 提现开关状态，1:打开；2:关闭
     * @see cn.com.duiba.kjj.center.api.enums.seller.SellerAccountWithdrawSwitchEnum
     */
    private Integer withdrawSwitch;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}