package cn.com.duiba.kjj.center.api.dto.vip.order;

import lombok.Data;

import java.io.Serializable;

/**
 * VIP付费-退款金额相关
 * @author lizhi
 * @date 2021/11/24 4:50 下午
 */
@Data
public class VipOrderRefundAmountInfoDto implements Serializable {

    private static final long serialVersionUID = -7899105430096800307L;

    /**
     * 订单金额
     */
    private int amount;

    /**
     * 可退金额，等于 订单金额-已退款金额-已结算返佣金额
     */
    private int canRefundAmount;

    /**
     * 已退款金额（包含待审核的、审核成功的）
     */
    private int refundedAmount;

    /**
     * 待结算返佣金额
     */
    private int dealingReturnAmount;

    /**
     * 已结算返佣金额
     */
    private int settleReturnAmount;
}
