package cn.com.duiba.kjj.center.api.param.content;

import cn.com.duiba.kjj.center.api.param.common.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 内容数据统计表
 * @author kjj mybatis generator 
 * @date 2021-11-30
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class ContentStatisticsSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16382817904318121L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 内容id
     */
    private Long contentId;

    /**
     * 内容类型
     */
    private String contentType;

    /**
     * 阅读次数
     */
    private Long readNum;

    /**
     * 分享次数
     */
    private Long shareNum;

    /**
     * 下载次数
     */
    private Long downloadNum;

    /**
     * 关注数
     */
    private Long attentionNum;

    /**
     * 精准素材分享次数，仅提供给精准素材专用
     */
    private Long accurateShareNum;

    /**
     * 是否删除 1-删除 0-未删除
     */
    private Byte deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 代理人内容uv数(去重)
     */
    private Long sellerUvNum;

    /**
     * 代理人转发数(去重)
     */
    private Long sellerForwardNum;

    /**
     * 代理人转发率
     */
    private Byte sellerForwardRate;
}