package cn.com.duiba.kjj.center.api.param.vip.order;

import cn.com.duiba.kjj.center.api.param.common.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 付款退款记录表
 * @author kjj mybatis generator 
 * @date 2021-11-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class OrderRefundSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16377204249671103L;

    /**
     * 付款订单ID
     */
    private Long payOrderId;

    /**
     * 微信的支付ID
     */
    private String payWxId;

    /**
     * 退款业务订单号
     */
    private String bizRefundNo;

    /**
     * 销售ID
     */
    private Long sellerId;

    /**
     * 提交人ID
     */
    private Long submitterId;

    /**
     * 操作人
     */
    private String submitter;

    /**
     * 审核状态
     * {@link cn.com.duiba.kjj.center.api.enums.vip.order.OrderRefundCheckStatusEnum}
     */
    private Integer checkStatus;

    /**
     * 支付结果时间-开始时间
     */
    private Date startPayResultTime;

    /**
     * 支付结果时间-开始时间
     */
    private Date endPayResultTime;
}