package cn.com.duiba.kjj.center.api.param.vip.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * vip付费-发起退款参数
 * @author lizhi
 * @date 2021/11/24 6:14 下午
 */
@Data
public class VipOrderRefundStartParam implements Serializable {

    private static final long serialVersionUID = 6017794356550742576L;

    /**
     * 付款订单ID，tb_seller_pay_record.id
     */
    private Long payOrderId;

    /**
     * 退款金额
     */
    private Integer refundAmount;

    /**
     * 退款申请来源：1:后台操作发起 2:完成60天打卡任务，系统发起
     * @see cn.com.duiba.kjj.center.api.enums.vip.order.OrderRefundSourceEnum
     */
    private Integer refundSource;

    /**
     * 提交人ID（sso的adminId）
     */
    private Long submitterId;

    /**
     * 提交人姓名（sso的adminName）
     */
    private String submitter;

    /**
     * 提交审批备注
     */
    private String submitRemark;
}
