package cn.com.duiba.kjj.center.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjj.center.api.dto.seller.SellerContentDto;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-11-22 16:48
 * 销售素材service
 */
@AdvancedFeignClient
public interface RemoteSellerContentService {

    /**
     * 根据scId获取销售信息和素材信息
     * @param scId 销售素材id
     * @return 销售信息和素材信息
     */
    SellerContentDto findById(Long scId);

    /**
     * 更新阅读数
     *
     * @param id 主键id
     * @return 执行结果
     */
    int increaseReadNum(Long id);
}
