package cn.com.duiba.kjj.center.api.remoteservice.vip.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjj.center.api.dto.vip.order.OrderRefundDto;
import cn.com.duiba.kjj.center.api.dto.vip.order.VipOrderRefundAmountInfoDto;
import cn.com.duiba.kjj.center.api.param.vip.order.OrderRefundSearchParam;
import cn.com.duiba.kjj.center.api.param.vip.order.VipOrderRefundStartParam;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.wxpay.WxPayRefundNotifyResponse;

import java.util.List;

/**
 * 会员付费-退款组合业务处理相关
 *
 * @author lizhi
 * @date 2021/11/26 6:37 下午
 */
@AdvancedFeignClient
public interface RemoteVipOrderRefundService {

    /**
     * 发起退款，加入审批流程
     * @param startParam 发起退款参数
     * @return 是否成功
     */
    boolean start(VipOrderRefundStartParam startParam);

    /**
     * 支付系统退款结果回调
     * @param response 回调对象
     * @return 是否处理成功
     */
    boolean refundNotify(WxPayRefundNotifyResponse response);

    /**
     * 查询订单退款相关金额信息
     * @param payOrderId VIP付费订单主键
     * @return 退款相关金额信息
     */
    VipOrderRefundAmountInfoDto findRefundAmountByPayOrderId(Long payOrderId);

    /**
     * 查询记录的总记录数 ( 管理后台专用 )
     *
     * @param param       查询参数
     * @return 总记录数
     */
    Long selectCount(OrderRefundSearchParam param);

    /**
     * 分页查询列表 ( 管理后台专用 )
     *
     * @param param 查询参数
     * @return 测试列表
     */
    List<OrderRefundDto> selectList(OrderRefundSearchParam param);

    /**
     * 根据主键查询退款记录
     *
     * @param id 主键Id
     * @return 退款记录
     */
    OrderRefundDto findById(Long id);

    /**
     * 根据主键列表查询退款记录列表
     *
     * @param ids 主键列表
     * @return 退款记录列表
     */
    List<OrderRefundDto> findByIds(List<Long> ids);

}
