package cn.com.duiba.kjj.center.api.dto.clue;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户访问记录表
 * @author kjj mybatis generator 
 * @date 2021-11-23
 */
@Data
public class UserVisitDto implements Serializable {
     
    private static final long serialVersionUID = 16376370249867065L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer deleted;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 销售员ID，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 内容ID，对应tb_content.id
     */
    private Long contentId;

    /**
     * 销售员内容ID，对应tb_seller_content.id
     */
    private Long scid;

    /**
     * 记录类型：article =文章、seller =名片 activity =活动 daily=日报 card =名片2.0
     */
    private String contentType;

    /**
     * 阅读时长，单位：秒
     */
    private Long readDuration;

    /**
     * 阅读深度：百分比
     */
    private Integer readDepth;

    /**
     * 阅读标志：0=未读、1=已读
     */
    private Integer readMark;

    /**
     * 第几次访问，用户id、销售员id
     */
    private Integer readNum;

    /**
     * 访问用户ID，对应tb_users.id
     */
    private Long visitId;

    /**
     * 推送类型：1-实时推送，0-非实时推送
     */
    private Integer pushType;

    /**
     * 是否已曝光 0=未曝光 1=已曝光
     */
    private Integer isExposed;

    /**
     * 访客访问路径 0:未知,1:个人,2:朋友圈,3:群
     */
    private Integer visitPath;

    /**
     * 业务编号
     */
    private String bizNo;

    /**
     * 产生线索类型,二进制转十进制存储，对应UserClueTypeEnum
     */
    private Long clueSwitches;

    /**
     * 来源scid
     */
    private Long sourceScid;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}