package cn.com.duiba.kjj.center.api.dto.seller;

import lombok.Data;

import java.io.Serializable;

/**
 * 销售员
 * @author kjj mybatis generator
 * @date 2021-11-09
 */
@Data
public class SellerContentDto implements Serializable {

    private static final long serialVersionUID = -2438691504383944643L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 内容ID，对应tb_content.id
     */
    private Long contentId;

    /**
     * 内容类型，对应tb_content.contentType
     */
    private String contentType;

    /**
     * 销售员ID，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 阅读数
     */
    private Long readNum;

    /**
     * 是否展示我的名片，0=不展示、1=展示
     */
    private Integer showCard;

    /**
     * 活动表单数
     */
    private Long formNum;

    /**
     * 是否首次访问，用户推动通知，0=不是、1=是
     */
    private Integer firstVisit;

    /**
     * 自定义素材类型
     */
    private Integer customContentType;

    /**
     * 状态 1:正常 2:已删除
     */
    private Integer contentStatus;

}