package cn.com.duiba.kjj.center.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjj.center.api.dto.clue.UpdateDurationDto;
import cn.com.duiba.kjj.center.api.dto.clue.UserVisitDto;
import cn.com.duiba.kjj.center.api.dto.clue.UserVisitRedisDto;
import cn.com.duiba.kjj.center.api.dto.clue.UserVisitResultDto;
import cn.com.duiba.kjj.center.api.dto.clue.UserVisitTraceDto;

import java.util.List;

/**
 * 访问记录rpc
 *
 * @author xuzhigang
 * @date 2021/11/23 2:41 下午
 **/
@AdvancedFeignClient
public interface RemoteUserVisitService {
    /**
     * 更新阅读时长 累加
     *
     * @param list 阅读时长参数
     * @return 执行结果
     */
    int batchUpdateDuration(List<UpdateDurationDto> list);

    /**
     * 新增访问记录
     *
     * @param userVisitDto 访问记录信息
     * @param userVisitTraceDto 访问链路信息
     * @return 结果
     */
    UserVisitResultDto addUserVisit(UserVisitDto userVisitDto, UserVisitTraceDto userVisitTraceDto);

    /**
     * 根据scId和访客id查询最近10分钟的访问记录
     * redis中查询
     *
     * @param scId 销售内容id
     * @param visitId 访客id
     * @return 访问记录
     */
    UserVisitRedisDto findLast10MinUserVisitAndTrace(Long scId, Long visitId);

    /**
     * 根据scId和pushType查询访问记录
     *
     * @param scId tb_seller_content.id
     * @param pushType {@link cn.com.duiba.kjj.center.api.enums.clue.UserVisitPushTypeEnum}
     * @return 访问记录
     */
    UserVisitDto selectOneByScIdAndPushType(Long scId, Integer pushType);

    /**
     * 查询最新一次访问次数
     *
     * @param sellerId 销售id
     * @param visitId 访客id
     * @return 访问次数
     */
    int selectLastReadNum(Long sellerId, Long visitId);

    /**
     * 根据id获取访问列表
     * @param ids 访问ids
     * @return 访问列表
     */
    List<UserVisitDto> findByIds(List<Long> ids);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 用户访问记录
     */
    UserVisitDto selectById(Long id);
}
