package cn.com.duiba.kjj.center.api.remoteservice.vip.promotion;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjj.center.api.dto.vip.promotion.PromotionCodeDto;

/**
 * 优惠码
 * @author lizhi
 * @date 2021/11/12 11:50 上午
 */
@AdvancedFeignClient
public interface RemotePromotionCodeService {

    /**
     * 根据优惠码查询
     * @param promotionCode 优惠码
     * @return 邀请码
     */
    PromotionCodeDto selectByCode(String promotionCode);

    /**
     * 查询用户最近锁定的一个优惠码
     * @param userId 用户ID
     * @return 用户锁定的优惠码
     */
    PromotionCodeDto getUserLockingPromotion(Long userId);

    /**
     * 获取首个加锁或已经使用的优惠码
     * @param userId 用户id
     * @param batchId 优惠码批次id
     * @return 首个加锁或已经使用的优惠码
     */
    PromotionCodeDto findFirstLockOrUsed(Long userId, Long batchId);

    /**
     * 分配优惠码
     * @param batchId 优惠码批次id
     * @param sellerId 销售id
     * @param userId 用户id
     * @return 优惠码
     */
    String lockPromotionCode(Long batchId, Long sellerId, Long userId);
}
