package cn.com.duiba.kjj.center.api.dto.clue;

import java.io.Serializable;

import cn.com.duiba.kjj.center.api.enums.clue.ClueBizTypeEnum;
import lombok.Data;

/**
 * 销售员客户线索表
 * @author kjj mybatis generator 
 * @date 2021-12-15
 */
@Data
public class SellerVisitorClueDto implements Serializable {
     
    private static final long serialVersionUID = 16395484094659814L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * 访客Id tb_users.id 
     */
    private Long visitorId;

    /**
     * 代理人内容Id tb_seller_content.id
     */
    private Long scid;

    /**
     * 用户访问记录表主键tb_users_visit.id
     */
    private Long userVisitId;

    /**
     * 线索类型
     * {@link ClueBizTypeEnum}
     */
    private Integer clueBizType;

    /**
     * 对应的业务id
     */
    private Long clueBizId;

    /**
     * 来源的代理人内容id
     */
    private Long sourceScid;

    /**
     * false-未跟进 true-已跟进
     */
    private Boolean hasFollowed;
}