package cn.com.duiba.kjj.center.api.dto.content;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-11-11 15:40
 */
@Data
public class ContentDto implements Serializable {

    private static final long serialVersionUID = 2222674098997801173L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 标题
     */
    private String title;

    /**
     * 阅读数
     * 与ContentStatisticsSimpleDto中重复，暂时保留，需前端介入
     */
    private Long readNum;

    /**
     * 分享数
     * 与ContentStatisticsSimpleDto中重复，暂时保留，需前端介入
     */
    private Long sharedNum;

    /**
     * 状态，1=草稿、2=正常
     */
    private Integer status;

    /**
     * 原创
     */
    private String source;

    /**
     * 原文地址
     */
    private String sourceUrl;

    /**
     * 文章图片URL
     */
    private String mainImgUrl;

    /**
     * 内容类型：article=文章
     */
    private String contentType;

    /**
     * 排序：降序
     */
    private Long sort;

    /**
     * 文章地址OSS
     */
    private String textUrl;

    /**
     * 发布日期
     */
    private Date dailyReleaseTime;

    /**
     * 阿里云敏感词检测结果
     */
    private String suggestion;

    /**
     * 内容标签
     */
    private String contentTag;

    private String dataTag;

    private String systemDataTag;

    /**
     * 下载数
     * 与ContentStatisticsSimpleDto中重复，暂时保留，需前端介入
     */
    private Long downloadNum;

    /**
     * 是否是公有的
     *
     * @see cn.com.duiba.kjj.center.api.enums.content.ContentPubliclyEnum
     */
    private Integer publicly;

    /**
     * 是否是销售员上传的
     *
     * @see cn.com.duiba.kjj.center.api.enums.content.ContentSellerImportEnum
     */
    private Integer sellerImport;

    private Date timeOpening;

    /**
     * 首页配图，多图“,”隔开
     */
    private String homeImgUrl;

    /**
     * 推送的标题
     */
    private String pushTitle;

    /**
     * 内容素材vip版本
     *
     * @see cn.com.duiba.kjj.center.api.enums.content.ContentVersionEnum
     */
    protected Integer contentVersion;

    /**
     * 方图，分享时卡片的图
     */
    private String squareImg;

    /**
     * 高亮内容标题
     */
    private String highLightTitle;
}
