package cn.com.duiba.kjj.center.api.enums.clue;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 代理人动态类型枚举
 *
 * @author xuzhigang
 * @date 2021/11/29 4:32 下午
 **/
@Getter
@AllArgsConstructor
public enum SellerDynamicTypeEnum {

    VISIT(1, "访问"),
    FORWARD_MATERIAL(2, "转发素材"),
    FORWARD_CARD(3, "转发名片"),
    USE_MARKETING_TOOL(4, "使用营销工具"),
    GAIN_SALE_CLUE(5, "获得销售线索"),
    NEW_FOLLOW_CUSTOMER(6, "新增跟进客户"),
    ;
    /**
     * 枚举值
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;
}
