package cn.com.duiba.kjj.center.api.enums.process;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 审批流程类型
 * @author lizhi
 * @date 2021/11/24 11:35 上午
 */
@Slf4j
@Getter
@AllArgsConstructor
public enum ProcessFlowTypeEnum {

    REFUND_CHECK(2,"用户退款审批"),

    ;

    private final Integer code;
    private final String desc;

    private static final Map<Integer, ProcessFlowTypeEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(ProcessFlowTypeEnum::getCode, Function.identity(), (v1, v2) -> {
                log.error("ProcessFlowTypeEnum, type distinct, type={}", v2.getCode());
                return v2;
            }))
    );

    /**
     * 根据状态获取枚举
     * @param code 状态
     * @return 枚举
     */
    public static ProcessFlowTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
