package cn.com.duiba.kjj.center.api.enums.process;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 审批角色类型
 * @author lizhi
 * @date 2021/11/24 11:41 上午
 */
@Slf4j
@Getter
@AllArgsConstructor
public enum ProcessRoleTypeEnum {

    SALES_MANAGER(1, "销售主管"),

    FINANCE(2,"财务"),

    REFUND_FINANCE(3,"退款财务")
    ;

    private final Integer code;
    private final String desc;

    private static final Map<Integer, ProcessRoleTypeEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(ProcessRoleTypeEnum::getCode, Function.identity(), (v1, v2) -> {
                log.error("ProcessRoleTypeEnum, type distinct, type={}", v2.getCode());
                return v2;
            }))
    );

    /**
     * 根据状态获取枚举
     * @param code 状态
     * @return 枚举
     */
    public static ProcessRoleTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
