package cn.com.duiba.kjj.center.api.enums.push;


import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 推送类型枚举
 *
 * @author xuzhigang
 * @date 2021/12/17 5:07 下午
 **/
@Getter
@AllArgsConstructor
public enum PushTypeEnum {
    //推送类型
    DAILY(1, "今日早报更新", ""),
    AFTERNOON(2, "午后话题更新", ""),
    EVENING(3, "晚安心语更新", ""),
    HOT_ARTICLE(4, "爆款热文推荐", ""),
    VISIT(5, "意向客户来访", ""),
    DAILY_STATISTICS(6, "每日客户数据统计", ""),
    WEEKLY_STATISTICS(7, "每周客户数据统计", ""),
    DAILY_EARNINGS(8, "每日收益统计", ""),
    /**
     * 开启免打扰，一定要在PushLabelEnum.DISTURB标签下的第一个，前端对第一个做了特殊处理
     */
    NON_DISTURB(9, "开启免打扰", "开启后在设定时间内不会接收到消息推送"),

    INTERACT_EXPIRE_REMIND(10, "推送授权失效提醒", ""),

    DAILY_SIGN(11, "日签海报更新", ""),
    ;


    /**
     * 推送类型
     */
    private final Integer pushType;
    /**
     * 推送名称
     */
    private final String pushName;

    /**
     * 说明
     */
    private final String explain;

}
