package cn.com.duiba.kjj.center.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjj.center.api.dto.clue.CustomerNameAvatarDto;
import cn.com.duiba.kjj.center.api.dto.clue.SellerCustomerDto;

import java.util.List;
import java.util.Map;

/**
 * 销售客户信息
 *
 * @author xuzhigang
 * @date 2021/11/29 8:19 上午
 **/
@AdvancedFeignClient
public interface RemoteSellerCustomerService {
    /**
     * 添加销售客户信息
     * 已存在返回添加成功
     *
     * @param sellerCustomerDto 客户信息
     * @return 返回客户信息 null为添加失败
     */
    SellerCustomerDto addSellerCustomer(SellerCustomerDto sellerCustomerDto);

    /**
     * 根据销售id和客户id查询客户记录
     *
     * @param sellerId 销售id
     * @param userId 客户用户id
     * @return 客户信息
     */
    SellerCustomerDto selectOneBySellerIdAndUserId(Long sellerId, Long userId);

    /**
     * 根据销售id和客户id数组查询客户记录
     *
     * @param sellerId 销售id
     * @param visitUserIds 访客id
     * @return 客户列表
     */
    List<SellerCustomerDto> listBySidAndUserIds(Long sellerId, List<Long> visitUserIds);

    /**
     * 根据销售id和客户id数组查询客户链路
     *
     * @param sellerId 销售id
     * @param visitUserIds 客户用户id
     * @return 客户链路
     */
    Map<Long, List<CustomerNameAvatarDto>> listCustomerLink(Long sellerId, List<Long> visitUserIds);
}
