package cn.com.duiba.kjj.center.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjj.center.api.dto.clue.SellerVisitorClueDto;
import cn.com.duiba.kjj.center.api.dto.clue.SellerVisitorClueExtDto;
import cn.com.duiba.kjj.center.api.param.clue.ClueListSearchParam;
import cn.com.duiba.kjj.center.api.param.common.PageQuery;

import java.util.List;

/**
 * 线索rpc
 *
 * @author xuzhigang
 * @date 2021/12/15 4:43 下午
 **/
@AdvancedFeignClient
public interface RemoteSellerVisitorClueService {
    /**
     * 添加线索
     *
     * @param clueDto 线索
     * @param extDtoList 线索扩展信息(非必填)
     * @return true-添加成功 false-添加失败
     */
    Long addClue(SellerVisitorClueDto clueDto, List<SellerVisitorClueExtDto> extDtoList);

    /**
     * 根据上一次访问记录查询线索列表
     * @param clueListSearchParam 销售id，上次线索id
     * @return 线索列表
     */
    List<SellerVisitorClueDto> listBySidAndLastId(ClueListSearchParam clueListSearchParam);

    /**
     * 根据访问id获取线索列表
     * @param visitTableIds 访问id
     * @return 线索列表
     */
    List<SellerVisitorClueDto> listByVisitTableIds(List<Long> visitTableIds);

    /**
     * 线索-标记为已跟进
     * @param clueId 访问id
     * @return 标记结果
     */
    boolean followClue(Long clueId);
}
