/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.handler;

import cn.com.duiba.kjy.base.customweb.exception.ResponseNotClosedException;
import cn.com.duiba.kjy.base.customweb.exception.ResponseStatusException;
import cn.com.duiba.kjy.base.customweb.web.adaptor.RequestHandlerMappingAdaptor;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.factory.FilterChainFactory;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilterChain;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.HandlerExecutionChain;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.RequestMappings;
import cn.com.duiba.kjy.base.customweb.web.interceptor.KjjInterceptor;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherHandler {
    private static final Logger log = LoggerFactory.getLogger(DispatcherHandler.class);
    private final List<RequestMappings> requestMappingsList;
    private final List<KjjInterceptor> interceptorList;
    @Resource
    private FilterChainFactory filterChainFactory;

    public DispatcherHandler(List<RequestMappings> requestMappingsList, List<KjjInterceptor> interceptors) {
        this.requestMappingsList = requestMappingsList;
        this.interceptorList = interceptors;
    }

    public void handler(KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        httpRequest.setResponse(response);
        CustomFilterChain customFilterChain = this.filterChainFactory.getInstance(this);
        customFilterChain.filter(httpRequest, response);
    }

    public void service(KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        HandlerExecutionChain mappedHandler = this.getRequestMapping(httpRequest);
        if (Objects.isNull(mappedHandler)) {
            throw new ResponseStatusException(HttpResponseStatus.NOT_FOUND);
        }
        try {
            RequestHandlerMappingAdaptor adaptor = mappedHandler.getAdaptor();
            boolean stop = mappedHandler.applyPreHandle(httpRequest, response, mappedHandler.getHandler());
            if (stop) {
                if (!response.isClosed()) {
                    log.error("response is not closed in interceptor.uri = {}", (Object)httpRequest.uri());
                    throw new ResponseNotClosedException();
                }
                return;
            }
            Object result = adaptor.handler(mappedHandler.getHandler(), httpRequest, response);
            mappedHandler.applyPostHandle(httpRequest, response, mappedHandler.getHandler(), result);
            adaptor.handlerResult(result, httpRequest, response, mappedHandler.getHandler());
            mappedHandler.afterCompletion(httpRequest, response, null);
        }
        catch (Exception e) {
            mappedHandler.afterCompletion(httpRequest, response, e);
            throw e;
        }
    }

    public HandlerExecutionChain getRequestMapping(KjjHttpRequest httpRequest) {
        for (RequestMappings requestMappings : this.requestMappingsList) {
            Object handler = requestMappings.getHandler(httpRequest);
            if (!Objects.nonNull(handler)) continue;
            return new HandlerExecutionChain(this.interceptorList, requestMappings, handler);
        }
        return null;
    }
}

