/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.handler.exception;

import cn.com.duiba.kjy.base.customweb.exception.ExceptionHandlerException;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.handler.exception.DefaultExceptionHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.exception.ExceptionHandler;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionChain {
    private static final Logger log = LoggerFactory.getLogger(ExceptionChain.class);
    @Resource
    private DefaultExceptionHandler defaultExceptionHandler;
    private final List<ExceptionHandler> exceptionHandlerList;

    public ExceptionChain(List<ExceptionHandler> exceptionHandlerList) {
        this.exceptionHandlerList = exceptionHandlerList;
    }

    public void handlerException(KjjHttpRequest request, KjjHttpResponse response, Throwable e) {
        try {
            for (ExceptionHandler exceptionHandler : this.exceptionHandlerList) {
                if (!exceptionHandler.doHandler(request, response, e)) continue;
                return;
            }
        }
        catch (Exception e2) {
            this.defaultExceptionHandler.doHandler(request, response, new ExceptionHandlerException(e, e2));
        }
    }
}

