/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.handler.mapping;

import cn.com.duiba.kjy.base.customweb.web.adaptor.RequestHandlerMappingAdaptor;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.RequestMappings;
import cn.com.duiba.kjy.base.customweb.web.interceptor.KjjInterceptor;
import java.util.List;

public class HandlerExecutionChain {
    private final List<KjjInterceptor> interceptors;
    private final RequestMappings requestMappings;
    private final Object handler;

    public HandlerExecutionChain(List<KjjInterceptor> kjjInterceptors, RequestMappings requestMappings, Object handler) {
        this.requestMappings = requestMappings;
        this.interceptors = kjjInterceptors;
        this.handler = handler;
    }

    public boolean applyPreHandle(KjjHttpRequest fullHttpRequest, KjjHttpResponse response, Object controllerMappingHandler) {
        for (KjjInterceptor kjjInterceptor : this.interceptors) {
            if (kjjInterceptor.applyPreHandle(fullHttpRequest, response, controllerMappingHandler)) continue;
            return true;
        }
        return false;
    }

    public void applyPostHandle(KjjHttpRequest request, KjjHttpResponse response, Object handler, Object result) {
        for (KjjInterceptor kjjInterceptor : this.interceptors) {
            kjjInterceptor.applyPostHandle(request, response, handler, result);
        }
    }

    public void afterCompletion(KjjHttpRequest request, KjjHttpResponse response, Exception e) {
        for (KjjInterceptor kjjInterceptor : this.interceptors) {
            kjjInterceptor.afterCompletion(request, response, this.handler, e);
        }
    }

    public RequestHandlerMappingAdaptor getAdaptor() {
        return this.requestMappings.getAdaptor();
    }

    public List<KjjInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public RequestMappings getRequestMappings() {
        return this.requestMappings;
    }

    public Object getHandler() {
        return this.handler;
    }
}

