/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.handler.response.impl;

import cn.com.duiba.kjy.base.customweb.util.ParamReflectUtil;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.handler.response.ResponseHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.http.entity.ContentType;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionService;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Order(value=-2147483548)
public class JacksonHandler
implements ResponseHandler {
    @Resource
    private ConversionService conversionService;
    @Resource
    private ObjectMapper objectMapper;

    @Override
    public boolean canWrite(Method method, Class<?> returnType) {
        return method.getDeclaringClass().isAnnotationPresent(RestController.class) || method.isAnnotationPresent(ResponseBody.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Object result, KjjHttpRequest kjjHttpRequest, KjjHttpResponse kjjHttpResponse) throws Throwable {
        try {
            kjjHttpResponse.setContentType(ContentType.APPLICATION_JSON.getMimeType());
            if (Objects.isNull(result)) {
            } else if (ParamReflectUtil.isPrimitive(result.getClass())) {
                String value = (String)this.conversionService.convert(result, String.class);
                kjjHttpResponse.write(value);
            } else {
                String s = this.objectMapper.writeValueAsString(result);
                kjjHttpResponse.write(s);
            }
        }
        finally {
            kjjHttpResponse.flushAndClose();
        }
    }
}

