/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.codec.convert;

import cn.com.duiba.kjy.base.api.utils.IdMakeUtil;
import cn.com.duiba.kjy.base.customweb.web.codec.IdDecode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.ObjectUtils;

public class IdListConvert
implements ConditionalGenericConverter {
    private static final Logger log = LoggerFactory.getLogger(IdListConvert.class);

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return targetType.hasAnnotation(IdDecode.class);
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object[].class, List.class));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (Objects.isNull(source)) {
            return null;
        }
        if (!source.getClass().isArray()) {
            log.error("can not convert target={} to Long[]", source);
            return null;
        }
        try {
            List<Object> sourceList = Arrays.asList(ObjectUtils.toObjectArray((Object)source));
            return sourceList.stream().map(s -> IdMakeUtil.decodingId(s.toString())).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("can not convert target={} to Long[]", source, (Object)e);
            return null;
        }
    }
}

