/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.factory;

import cn.com.duiba.kjy.base.customweb.web.bean.ParameterBean;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.ControllerMapping;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.ControllerMappingHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.ControllerMappingHandlerBuilder;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.RequestMappingInfo;
import cn.com.duiba.kjy.base.customweb.web.handler.response.ResponseHandler;
import cn.com.duiba.kjy.base.customweb.web.processor.parameter.ParameterPostProcessor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.web.bind.annotation.RequestMapping;

public class HandlerMappingBeanFactory {
    private static final Logger log = LoggerFactory.getLogger(HandlerMappingBeanFactory.class);
    @Resource
    private ControllerMapping controllerMapping;
    private final List<ParameterPostProcessor> parameterPostProcessors;
    private final List<ResponseHandler> responseHandlers;

    public HandlerMappingBeanFactory(List<ParameterPostProcessor> parameterPostProcessors, List<ResponseHandler> responseHandlers) {
        this.parameterPostProcessors = parameterPostProcessors;
        this.responseHandlers = responseHandlers;
    }

    public void builderHandlerMappingAndRegister(Class<?> handlerClass, List<Method> handlerMethodList, Object bean) {
        if (CollectionUtils.isEmpty(handlerMethodList)) {
            return;
        }
        for (Method method : handlerMethodList) {
            ControllerMappingHandler controllerMappingHandler = this.buildOneHandlerMapping(handlerClass, method, bean);
            this.controllerMapping.registerHandler(controllerMappingHandler);
        }
    }

    private ControllerMappingHandler buildOneHandlerMapping(Class<?> handlerClass, Method handlerMappingMethod, Object bean) {
        ControllerMappingHandlerBuilder controllerMappingHandlerBuilder = ControllerMappingHandlerBuilder.create(handlerClass, handlerMappingMethod);
        RequestMappingInfo mappingForMethod = this.getMappingForMethod(handlerMappingMethod, handlerClass);
        controllerMappingHandlerBuilder.setRequestMappingInfo(mappingForMethod);
        Class<?> returnType = handlerMappingMethod.getReturnType();
        controllerMappingHandlerBuilder.setReturnType(returnType);
        controllerMappingHandlerBuilder.setResponseHandler(this.getResponseHandler(handlerMappingMethod, returnType));
        controllerMappingHandlerBuilder.setHandlerObject(bean);
        this.fillParameterList(handlerClass, handlerMappingMethod, controllerMappingHandlerBuilder);
        return controllerMappingHandlerBuilder.build();
    }

    private void fillParameterList(Class<?> handlerClass, Method handlerMappingMethod, ControllerMappingHandlerBuilder controllerMappingHandlerBuilder) {
        Parameter[] parameters = handlerMappingMethod.getParameters();
        ArrayList<ParameterBean> parameterBeans = new ArrayList<ParameterBean>();
        int index = 0;
        for (Parameter parameter : parameters) {
            ParameterBean parameterBean = new ParameterBean();
            Class<?> type = parameter.getType();
            parameterBean.setType(type);
            parameterBean.setName(parameter.getName());
            parameterBean.setPrimitive(type.isPrimitive());
            parameterBean.setMethodParameter(new MethodParameter(handlerMappingMethod, index++));
            this.processorParameter(parameterBean, handlerClass, handlerMappingMethod);
            parameterBeans.add(parameterBean);
        }
        controllerMappingHandlerBuilder.setParamList(parameterBeans);
    }

    private String getPathAndInsertSlashBefore(String[] value, Class<?> handlerClass) {
        if (Objects.isNull(value) || value.length == 0) {
            return "";
        }
        if (value.length > 1) {
            throw new UnsupportedOperationException("there is so many value of annotation mapping in class: " + handlerClass.getName());
        }
        String v = value[0];
        if (StringUtils.isNotBlank((CharSequence)v) && !v.startsWith("/")) {
            return "/" + v;
        }
        return v;
    }

    private void processorParameter(ParameterBean parameterBean, Class<?> handlerBeanClass, Method method) {
        for (ParameterPostProcessor parameterPostProcessor : this.parameterPostProcessors) {
            parameterPostProcessor.postProcessorParameter(parameterBean, handlerBeanClass, method);
        }
    }

    private ResponseHandler getResponseHandler(Method method, Class<?> returnType) {
        for (ResponseHandler responseHandler : this.responseHandlers) {
            if (!responseHandler.canWrite(method, returnType)) continue;
            return responseHandler;
        }
        throw new UnsupportedOperationException("can not write this type " + returnType.getName() + "in method" + method.getName());
    }

    private RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo info = this.createRequestMappingInfo(method);
        if (info != null) {
            RequestMappingInfo typeInfo = this.createRequestMappingInfo(handlerType);
            if (typeInfo != null) {
                info = typeInfo.combine(info);
            }
            info = RequestMappingInfo.paths("/").build().combine(info);
        }
        return info;
    }

    private RequestMappingInfo createRequestMappingInfo(AnnotatedElement element) {
        RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, RequestMapping.class);
        return this.createRequestMappingInfo(requestMapping);
    }

    protected RequestMappingInfo createRequestMappingInfo(RequestMapping requestMapping) {
        return RequestMappingInfo.paths(requestMapping.path()).methods(requestMapping.method()).mappingName(requestMapping.name()).build();
    }
}

