/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.processor;

import cn.com.duiba.kjy.base.customweb.web.factory.HandlerMappingBeanFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

public class ControllerBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(ControllerBeanPostProcessor.class);
    @Resource
    private HandlerMappingBeanFactory handlerMappingBeanFactory;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private Annotation getControllerAnnotation(Class<?> beanClass) {
        Controller controllerAnnotation = beanClass.getDeclaredAnnotation(Controller.class);
        if (Objects.nonNull(controllerAnnotation)) {
            return controllerAnnotation;
        }
        return beanClass.getDeclaredAnnotation(RestController.class);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> beanClass = bean.getClass();
        Annotation ctrlAnnotation = this.getControllerAnnotation(beanClass);
        if (Objects.isNull(ctrlAnnotation)) {
            return bean;
        }
        ArrayList<Method> hanMethodList = new ArrayList<Method>();
        for (Method handleMethod : beanClass.getDeclaredMethods()) {
            if (!handleMethod.isAnnotationPresent(GetMapping.class) && !handleMethod.isAnnotationPresent(PostMapping.class) && !handleMethod.isAnnotationPresent(RequestMapping.class)) continue;
            hanMethodList.add(handleMethod);
        }
        this.handlerMappingBeanFactory.builderHandlerMappingAndRegister(beanClass, hanMethodList, bean);
        return bean;
    }
}

