package cn.com.duiba.kjy.base.customweb.autoconfig;

import cn.com.duiba.kjy.base.customweb.web.factory.FilterChainFactory;
import cn.com.duiba.kjy.base.customweb.web.filter.ActuateFilter;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomCatWebFilter;
import cn.com.duiba.kjy.base.customweb.web.filter.KjjAccessLogFilter;
import cn.com.duiba.kjy.base.customweb.web.filter.MonitorFilter;
import cn.com.duiba.kjy.base.customweb.web.processor.ControllerBeanPostProcessor;
import cn.com.duiba.kjy.base.customweb.web.processor.FilterBeanPostProcessor;
import com.dianping.cat.Cat;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author dugq
 * @date 2021/3/28 11:38 下午
 */
@Configuration
@AutoConfigureBefore(NettyAutoConfiguration.class)
@ConditionalOnProperty(name="duiba.server.enable", havingValue = "true", matchIfMissing = false)
public class FilterAutoConfig {

    @Bean
    public FilterChainFactory filterChainFactory(){
        return new FilterChainFactory();
    }

    @Bean
    public static FilterBeanPostProcessor filterBeanPostProcessor(){
        return new FilterBeanPostProcessor();
    }

    @Bean
    public static ControllerBeanPostProcessor handlerBeanPostProcessor(){
        return new ControllerBeanPostProcessor();
    }



    @Bean
    public MonitorFilter monitorFilter(){
        return new MonitorFilter();
    }

    @Bean
    public ActuateFilter actuateFilter(){
        return new ActuateFilter();
    }

    @Bean
    @ConditionalOnClass(Cat.class)
    public CustomCatWebFilter customCatWebFilter(){
        return new CustomCatWebFilter();
    }

    @Bean
    public KjjAccessLogFilter kjjAccessLogFilter(){
        return new KjjAccessLogFilter();
    }
}
