package cn.com.duiba.kjy.base.customweb.autoconfig;

import cn.com.duiba.kjy.base.customweb.sever.CustomNettyServer;
import cn.com.duiba.kjy.base.customweb.sever.NettyProps;
import cn.com.duiba.kjy.base.customweb.web.handler.DispatcherHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.exception.ExceptionChain;
import io.netty.channel.nio.NioEventLoopGroup;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author dugq
 * @date 2020-08-10 12:14
 */
@Configuration
@Slf4j
@ConditionalOnProperty(name="duiba.server.enable", havingValue = "true", matchIfMissing = false)
@ConditionalOnMissingBean(WebServer.class)
public class NettyAutoConfiguration {
    @Resource
    private DispatcherHandler dispatcherHandler;

    @Resource
    private NettyProps nettyConfig;

    @Resource
    private ExceptionChain exceptionChain;


    @Bean
    public CustomNettyServer getWebServer() {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(8, new ThreadFactory() {
            private final AtomicInteger index = new AtomicInteger(0);

            public Thread newThread(Runnable r) {
                return new Thread(r, "netty-BOSS_" + index.incrementAndGet());
            }
        });

        NioEventLoopGroup workGroup = new NioEventLoopGroup(8, new ThreadFactory() {
            private final AtomicInteger index = new AtomicInteger(0);

            public Thread newThread(Runnable r) {
                return new Thread(r, "netty-WORK_" + index.incrementAndGet());
            }
        });

        final CustomNettyServer customNettyServer = new CustomNettyServer(nettyConfig, bossGroup, workGroup, dispatcherHandler,exceptionChain);
        customNettyServer.start();
        return customNettyServer;
    }


}
