package cn.com.duiba.kjy.base.customweb.autoconfig;

import cn.com.duiba.kjy.base.customweb.web.adaptor.RequestHandlerMappingAdaptor;
import cn.com.duiba.kjy.base.customweb.web.factory.HandlerMappingBeanFactory;
import cn.com.duiba.kjy.base.customweb.web.handler.DispatcherHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.RequestMappings;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.ControllerMapping;
import cn.com.duiba.kjy.base.customweb.web.handler.response.ResponseHandler;
import cn.com.duiba.kjy.base.customweb.web.interceptor.KjjInterceptor;
import cn.com.duiba.kjy.base.customweb.web.processor.parameter.ParameterPostProcessor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.OrderComparator;
import org.springframework.http.converter.HttpMessageConverter;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author dugq
 * @date 2021/3/25 4:06 下午
 */
@Configuration
@AutoConfigureBefore(NettyAutoConfiguration.class)
@ConditionalOnProperty(name="duiba.server.enable", havingValue = "true", matchIfMissing = false)
public class NettyWebAutoConfig {

    @Bean
    public RequestHandlerMappingAdaptor requestHandlerMappingAdaptor(){
        return new RequestHandlerMappingAdaptor();
    }


    @Bean
    public HandlerMappingBeanFactory handlerMappingBeanFactory(ObjectProvider<ParameterPostProcessor> parameterPostProcessors, ObjectProvider<ResponseHandler> responseHandlers){
        final List<ParameterPostProcessor> parameterPostProcessorList = parameterPostProcessors.stream().collect(Collectors.toList());
        final List<ResponseHandler> responseHandlerList = responseHandlers.stream().sorted(OrderComparator.INSTANCE).collect(Collectors.toList());
        return new HandlerMappingBeanFactory(parameterPostProcessorList, responseHandlerList);
    }

    @Bean
    public DispatcherHandler dispatcherHandler(ObjectProvider<RequestMappings> requestMappingsList, ObjectProvider<KjjInterceptor> interceptors){
        final List<RequestMappings> requestMappings = requestMappingsList.stream().sorted(OrderComparator.INSTANCE).collect(Collectors.toList());
        final List<KjjInterceptor> interceptorList = interceptors.stream().sorted(OrderComparator.INSTANCE).collect(Collectors.toList());
        return new DispatcherHandler(requestMappings,interceptorList);
    }

    /**
     * 重新注册http消息转换类。注意：此类是spring-web 框架使用的，实则适用tomcat的，但由于RPC也使用到，所以再加回来。
     * 有此类，上述的自定义converter才生效
     */
    @Bean
    @ConditionalOnMissingBean
    public HttpMessageConverters messageConverters(ObjectProvider<HttpMessageConverter<?>> converters) {
        return new HttpMessageConverters(converters.orderedStream().collect(Collectors.toList()));
    }

    @Bean
    public ControllerMapping controllerMapping(){
        return new ControllerMapping();
    }

}
