package cn.com.duiba.kjy.base.customweb.sever;

import lombok.Data;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

import javax.annotation.Resource;

/**
 * @author dugq
 * @date 2020-08-10 12:36
 */
@ConfigurationProperties(prefix = "kjj.netty")
@AutoConfigureAfter(ServerProperties.class)
@Data
public class NettyProps {
    @Resource
    private ServerProperties serverProperties;

    private int workThread=4;

    private int bossThread=16;

    private int nettyPort = serverProperties.getPort();

}
