package cn.com.duiba.kjy.base.customweb.web.adaptor;

import cn.com.duiba.kjy.base.customweb.exception.ArgResolverException;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.bean.ParameterBean;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.ControllerMappingHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.response.ResponseHandler;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/3/24 11:47 下午
 */
@Slf4j
public class RequestHandlerMappingAdaptor {

    public Object handler(Object handler, KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        ControllerMappingHandler handlerMapping = (ControllerMappingHandler)handler;
        final List<ParameterBean> paramList = handlerMapping.getParamList();
        final Object[] params = getArgs(httpRequest, paramList,response);
        if (Objects.equals(handlerMapping.getReturnType(),Void.class)){
            handlerMapping.getHandlerMethod().invoke(handlerMapping.getHandlerObject(),params);
            return null;
        }
        return handlerMapping.getHandlerMethod().invoke(handlerMapping.getHandlerObject(),params);
    }

    @NotNull
    private Object[] getArgs(KjjHttpRequest httpRequest, List<ParameterBean> paramList, KjjHttpResponse response) throws Throwable {
        if (CollectionUtils.isEmpty(paramList)){
            return new Object[0];
        }
        try {
            List<Object> list = new ArrayList<>();
            for (ParameterBean parameterBean : paramList) {
                Object arg = parameterBean.getArgsResolver().doResolver(parameterBean, httpRequest,response);
                list.add(arg);
            }
            return list.toArray();
        }catch (Throwable th){
            throw new ArgResolverException("arguments resolver has error ! uri = "+ httpRequest.uri(),th);
        }
    }

    public void handlerResult(Object result, KjjHttpRequest httpRequest, KjjHttpResponse response, Object handler) throws Throwable {
        ControllerMappingHandler handlerMapping = (ControllerMappingHandler)handler;
        final ResponseHandler responseHandler = handlerMapping.getResponseHandler();
        responseHandler.write(result,httpRequest,response);
    }
}
